/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.service.fragments.types;

import fr.toutatice.ecm.platform.service.fragments.FragmentServiceException;
import fr.toutatice.ecm.platform.service.fragments.types.Fragment;
import fr.toutatice.ecm.platform.web.fragments.configuration.ConfigurationBeanHelper;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;

public class PortletFragment
implements Fragment {
    private static final String PORTLET_SCHEMA = "portlet_fragments";
    private static final String PORTLET_PROPERTIES = "portlet_properties";

    @Override
    public String prepareCreation(DocumentModel doc, String uri, String region, String belowUri, String code2) throws FragmentServiceException {
        try {
            Map portletProperties;
            Map schPortlets = doc.getProperties(PORTLET_SCHEMA);
            Collection values = schPortlets.values();
            Object liste = values.iterator().next();
            if (liste instanceof List) {
                List listeData = (List)liste;
                HashMap<String, String> newEntry = new HashMap<String, String>();
                newEntry.put("refURI", uri);
                newEntry.put("portletInstance", code2);
                listeData.add(newEntry);
                doc.setProperties(PORTLET_SCHEMA, schPortlets);
            }
            if ((liste = (values = (portletProperties = doc.getProperties(PORTLET_PROPERTIES)).values()).iterator().next()) instanceof List) {
                List listeData = (List)liste;
                ConfigurationBeanHelper configBean = ConfigurationBeanHelper.getBean();
                List options = configBean.getFragmentOptionsByCode(doc, code2);
                if (options != null) {
                    for (Object optionObj : options) {
                        Map option = (Map)optionObj;
                        HashMap<String, String> newEntry = new HashMap<String, String>();
                        newEntry.put("refURI", uri);
                        newEntry.put("key", (String)option.get("propertyName"));
                        newEntry.put("value", (String)option.get("propertyDefaultValue"));
                        listeData.add(newEntry);
                    }
                    doc.setProperties(PORTLET_PROPERTIES, portletProperties);
                }
            }
        }
        catch (ClientException e) {
            throw new FragmentServiceException((Exception)((Object)e));
        }
        return uri;
    }
}

