/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.web.document;

import fr.toutatice.ecm.platform.core.helper.ToutaticeOperationHelper;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.webapp.action.DeleteActionsBean;

@Name(value="deleteActions")
@Scope(value=ScopeType.EVENT)
@Install(precedence=31)
public class ToutaticeDeleteActionsBean
extends DeleteActionsBean {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ToutaticeDeleteActionsBean.class);

    public boolean getCanDelete() {
        boolean status = super.getCanDelete();
        if (status) {
            status = this.additionalDeleteFilter("CURRENT_SELECTION");
        }
        return status;
    }

    public boolean getCanPurge() throws ClientException {
        boolean status = super.getCanPurge();
        if (status) {
            status = this.additionalDeleteFilter("CURRENT_SELECTION_TRASH");
        }
        return status;
    }

    public String deleteSelection() throws ClientException {
        List<DocumentModel> proxiedDocsList = this.getSelectionProxiesList("CURRENT_SELECTION");
        DocumentModel currentFolder = this.navigationContext.getCurrentDocument();
        if (!proxiedDocsList.isEmpty()) {
            try {
                ToutaticeOperationHelper.runOperationChain((CoreSession)this.documentManager, (String)"setOffLineSelection", (Object)new DocumentModelListImpl(proxiedDocsList));
            }
            catch (Exception e) {
                log.error((Object)("Failed to set offline the selection from the document: '" + currentFolder.getTitle() + "', error: " + e.getMessage()));
            }
        }
        return super.deleteSelection();
    }

    public String purgeSelection() throws ClientException {
        List<DocumentModel> proxiedDocsList = this.getSelectionProxiesList("CURRENT_SELECTION_TRASH");
        DocumentModel currentFolder = this.navigationContext.getCurrentDocument();
        if (!proxiedDocsList.isEmpty()) {
            try {
                ToutaticeOperationHelper.runOperationChain((CoreSession)this.documentManager, (String)"setOffLineSelection", (Object)new DocumentModelListImpl(proxiedDocsList));
            }
            catch (Exception e) {
                log.error((Object)("Failed to set offline the selection from the document: '" + currentFolder.getTitle() + "', error: " + e.getMessage()));
            }
        }
        return super.purgeSelection();
    }

    public boolean getCanDeleteSections() {
        List docs = this.documentsListsManager.getWorkingList("CURRENT_SELECTION_SECTIONS");
        for (DocumentModel doc : docs) {
            if (doc.hasFacet("Folderish")) continue;
            return false;
        }
        return super.getCanDeleteSections();
    }

    private boolean additionalDeleteFilter(String workingListName) {
        boolean status = true;
        if (!this.documentsListsManager.isWorkingListEmpty(workingListName)) {
            try {
                List docs = this.documentsListsManager.getWorkingList(workingListName);
                for (DocumentModel doc : docs) {
                    boolean hasProxy;
                    DocumentModelList proxies = this.documentManager.getProxies(doc.getRef(), doc.getParentRef());
                    boolean isApproved = "approved".equals(doc.getCurrentLifeCycleState());
                    boolean bl = hasProxy = null != proxies && !proxies.isEmpty();
                    if (!isApproved && !hasProxy || this.documentManager.hasPermission(doc.getRef(), "validationWorkflow_validation")) continue;
                    status = false;
                    break;
                }
            }
            catch (ClientException e) {
                log.error((Object)"Cannot check delete permission", (Throwable)e);
                status = false;
            }
        }
        return status;
    }

    private List<DocumentModel> getSelectionProxiesList(String selectionList) throws ClientException {
        ArrayList<DocumentModel> proxiedDocsList = new ArrayList<DocumentModel>();
        List docsList = this.documentsListsManager.getWorkingList(selectionList);
        if (null != docsList && 0 < docsList.size()) {
            for (DocumentModel document : docsList) {
                DocumentModelList proxies = this.documentManager.getProxies(document.getRef(), document.getParentRef());
                if (proxies.isEmpty()) continue;
                proxiedDocsList.add(document);
            }
        }
        return proxiedDocsList;
    }
}

