/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.web.fragments;

import fr.toutatice.ecm.platform.service.fragments.FragmentDescriptor;
import fr.toutatice.ecm.platform.service.fragments.FragmentService;
import fr.toutatice.ecm.platform.service.fragments.FragmentServiceException;
import fr.toutatice.ecm.platform.service.fragments.types.Fragment;
import fr.toutatice.ecm.platform.web.fragments.GenericActionBean;
import java.util.HashMap;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.web.RequestParameter;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.runtime.api.Framework;

@Name(value="fragmentBean")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=30)
public class FragmentActionBean
extends GenericActionBean {
    private static final Log log = LogFactory.getLog(FragmentActionBean.class);
    @RequestParameter(value="refURI")
    private String requestedRefUri;
    private String uri;
    @RequestParameter(value="region")
    private String requestedRegion;
    private String region;
    @RequestParameter(value="belowURI")
    private String requestedBelowUri;
    private String belowUri;
    private Map<String, String> listViewsParam = new HashMap<String, String>();
    private FragmentDescriptor descriptor;
    private FragmentService service;

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getBelowUri() {
        return this.belowUri;
    }

    public void setBelowUri(String belowUri) {
        this.belowUri = belowUri;
    }

    public Map<String, String> getListViewsParam() {
        if (this.listViewsParam.size() == 0) {
            this.listViewsParam.put("directoryName", "list-views");
        }
        return this.listViewsParam;
    }

    public FragmentDescriptor getDescriptor() {
        if (this.descriptor == null) {
            this.initDescriptor();
        }
        return this.descriptor;
    }

    public String dispatchCreation(String code, String code2) {
        try {
            Map.Entry fragmentInfos = this.getFragmentService().findByCode(code);
            if (fragmentInfos != null) {
                Fragment fragment = (Fragment)fragmentInfos.getValue();
                this.descriptor = (FragmentDescriptor)fragmentInfos.getKey();
                FacesContext context = FacesContext.getCurrentInstance();
                DocumentModel doc = (DocumentModel)context.getApplication().evaluateExpressionGet(context, "#{currentDocument}", DocumentModel.class);
                if (this.region != null || this.belowUri != null) {
                    this.uri = this.getFragmentService().prepareCreation(doc, fragment, code, this.region, this.belowUri, code2);
                } else {
                    this.addMessage("osivia.error.region_unbound");
                }
            } else {
                this.addMessage("osivia.error.fragment_not_found");
            }
        }
        catch (FragmentServiceException e) {
            this.addMessage(e.getMessage());
        }
        return "osivia_create_fragment_2";
    }

    private FragmentService getFragmentService() {
        if (this.service == null) {
            try {
                this.service = (FragmentService)Framework.getService(FragmentService.class);
            }
            catch (Exception e) {
                this.addMessage(e.getMessage());
            }
        }
        return this.service;
    }

    public void initDescriptor() {
        try {
            if (this.uri != null) {
                FacesContext context = FacesContext.getCurrentInstance();
                DocumentModel doc = (DocumentModel)context.getApplication().evaluateExpressionGet(context, "#{currentDocument}", DocumentModel.class);
                Map.Entry fragmentInfos = this.getFragmentService().getFragmentCategory(doc, this.uri);
                this.descriptor = (FragmentDescriptor)fragmentInfos.getKey();
            } else {
                this.addMessage("osivia.error.fragment_not_found");
            }
        }
        catch (FragmentServiceException e) {
            this.addMessage(e.getMessage());
        }
    }

    @Create
    public void startUp() {
        if (this.requestedRefUri != null) {
            this.uri = this.requestedRefUri;
        }
        if (this.requestedBelowUri != null) {
            this.belowUri = this.requestedBelowUri;
        }
        if (this.requestedRegion != null) {
            this.region = this.requestedRegion;
        }
    }
}

