/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.web.publication;

import fr.toutatice.ecm.platform.web.context.ToutaticeNavigationContext;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.platform.publisher.api.PublicationNode;
import org.nuxeo.ecm.platform.publisher.api.PublicationTree;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocument;
import org.nuxeo.ecm.platform.publisher.impl.core.SimpleCorePublishedDocument;
import org.nuxeo.ecm.platform.publisher.impl.service.ProxyNode;
import org.nuxeo.ecm.platform.publisher.impl.service.ProxyTree;
import org.nuxeo.ecm.platform.publisher.web.PublishActionsBean;

@Name(value="publishActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=31)
public class ToutaticePublishActionsBean
extends PublishActionsBean {
    private static final Log log = LogFactory.getLog(ToutaticePublishActionsBean.class);
    private static final long serialVersionUID = 1L;

    public boolean getCanPublish() throws ClientException {
        DocumentModel doc = this.navigationContext.getCurrentDocument();
        return this.getCanPublish(doc);
    }

    public boolean getCanPublish(DocumentModel document) throws ClientException {
        boolean status = false;
        try {
            if (null != document) {
                PublicationTree tree = this.getCurrentPublicationTreeForPublishing();
                DocumentModel parent = this.documentManager.getParentDocument(document.getRef());
                if (null != parent) {
                    DocumentModel proxy;
                    status = true;
                    DocumentModelList proxies = this.documentManager.getProxies(document.getRef(), parent.getRef());
                    if (proxies != null && !proxies.isEmpty() && (proxy = (DocumentModel)proxies.get(0)).getVersionLabel().equals(document.getVersionLabel())) {
                        status = false;
                    }
                    if (status) {
                        PublicationNode target = tree.getNodeByPath(parent.getPathAsString());
                        status = super.canPublishTo(target);
                    }
                }
            }
        }
        catch (Exception e) {
            log.debug((Object)("Failed to check the permission to publish the document '" + document.getTitle() + "', error: " + e.getMessage()));
        }
        return status;
    }

    public boolean getCanUnpublish() throws ClientException {
        DocumentModel doc = this.navigationContext.getCurrentDocument();
        return this.getCanUnpublish(doc);
    }

    public boolean canUnpublishProxy(DocumentModel proxy) throws ClientException {
        boolean status = false;
        if (!this.isRemoteProxy(proxy)) {
            status = this.documentManager.hasPermission(proxy.getRef(), "validationWorkflow_validation");
        } else {
            SimpleCorePublishedDocument publishedDocument = new SimpleCorePublishedDocument(proxy);
            status = super.canUnpublish((PublishedDocument)publishedDocument);
        }
        return status;
    }

    public boolean getCanUnpublish(DocumentModel document) throws ClientException {
        boolean status = false;
        try {
            DocumentModelList proxies;
            DocumentRef parentRef;
            if (null != document && null != (parentRef = this.documentManager.getParentDocumentRef(document.getRef())) && (proxies = this.documentManager.getProxies(document.getRef(), parentRef)) != null && !proxies.isEmpty()) {
                DocumentModel proxy = (DocumentModel)proxies.get(0);
                status = this.canUnpublishProxy(proxy);
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to check the permission to unpublish the document '" + document.getTitle() + "', error: " + e.getMessage()));
        }
        return status;
    }

    public boolean getCanPublishSelection() {
        boolean status = false;
        try {
            DocumentModel selectedDocument;
            List currentDocumentSelection = this.documentsListsManager.getWorkingList("CURRENT_SELECTION");
            Iterator i$ = currentDocumentSelection.iterator();
            while (i$.hasNext() && (status = this.getCanPublish(selectedDocument = (DocumentModel)i$.next()))) {
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to check permission to publish the selection, error: " + e.getMessage()));
        }
        return status;
    }

    public boolean getCanUnPublishSelection() {
        boolean status = false;
        try {
            DocumentModel selectedDocument;
            List currentDocumentSelection = this.documentsListsManager.getWorkingList("CURRENT_SELECTION");
            Iterator i$ = currentDocumentSelection.iterator();
            while (i$.hasNext() && (status = this.getCanUnpublish(selectedDocument = (DocumentModel)i$.next()))) {
            }
        }
        catch (Exception e) {
            log.error((Object)("Faild to check permission to unpublish the selection, error: " + e.getMessage()));
        }
        return status;
    }

    public boolean isRemoteProxy(DocumentModel proxy) {
        return proxy.isProxy() && !StringUtils.endsWith((String)proxy.getName(), (String)".proxy");
    }

    protected void getPathFragments(DocumentModel document, List<String> pathFragments) throws ClientException {
        pathFragments.add(document.getTitle());
        DocumentModel sectionRoot = ((ToutaticeNavigationContext)this.navigationContext).getSectionPublicationArea(document);
        if (!sectionRoot.equals(document)) {
            pathFragments.add(sectionRoot.getTitle());
        }
        DocumentModel domain = ((ToutaticeNavigationContext)this.navigationContext).getDocumentDomain(document);
        pathFragments.add(domain.getTitle());
    }

    public String getIconPath(Object node) throws ClientException {
        String iconPath = "";
        if (node instanceof ProxyNode) {
            String path = ((ProxyNode)node).getPath();
            PathRef pathRef = new PathRef(path);
            DocumentModel document = this.documentManager.getDocument((DocumentRef)pathRef);
            iconPath = (String)document.getProperty("common", "icon");
        }
        if (node instanceof ProxyTree) {
            iconPath = "/icons/domain.gif";
        }
        return iconPath;
    }

    public boolean getTrue() {
        return true;
    }
}

