/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.web.urlservice;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.platform.ui.web.rest.RestHelper;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.util.RepositoryLocation;

@Name(value="restHelper")
@Scope(value=ScopeType.EVENT)
@Install(precedence=31)
public class ToutaticeRestHelper
extends RestHelper {
    private static final Log log = LogFactory.getLog(ToutaticeRestHelper.class);
    @In(create=true, required=false)
    protected transient CoreSession documentManager;

    public String findWebId(DocumentView docView) {
        String outcome = null;
        if (docView != null) {
            DocumentLocation docLoc = docView.getDocumentLocation();
            String serverName = docLoc.getServerName();
            if (serverName != null) {
                String webid = docLoc.getPathRef().value;
                try {
                    DocumentModelList docs = this.documentManager.query("SELECT * FROM Document where ttc:webid = '" + webid + "'");
                    DocumentModel doc = (DocumentModel)docs.get(0);
                    docLoc = new DocumentLocationImpl(doc);
                    DocumentRef docRef = docLoc.getDocRef();
                    RepositoryLocation repoLoc = new RepositoryLocation(serverName);
                    if (docRef != null) {
                        if (docView.getParameter("mainTabId") == null && !this.webActions.hasCurrentTabId("MAIN_TABS")) {
                            this.webActions.setCurrentTabId("MAIN_TABS", "documents", new String[0]);
                        }
                        outcome = this.navigationContext.navigateTo(repoLoc, docRef);
                    } else {
                        this.navigationContext.setCurrentServerLocation(repoLoc);
                    }
                }
                catch (ClientException e) {
                    log.error((Object)("Impossible de traiter la weburl " + webid + ". " + (Object)((Object)e)));
                }
            }
            if (outcome == null) {
                outcome = docView.getViewId();
            }
        }
        return outcome;
    }
}

