/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.web.webeditor;

import fr.toutatice.ecm.platform.core.helper.ToutaticeFileHelper;
import fr.toutatice.ecm.platform.core.helper.ToutaticeImageCollectionHelper;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.web.RequestParameter;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.platform.ui.web.tag.fn.DocumentModelFunctions;
import org.nuxeo.ecm.platform.ui.web.util.files.FileUtils;
import org.nuxeo.ecm.webapp.documentsLists.DocumentsListsManager;
import org.nuxeo.ecm.webapp.note.EditorImageActionsBean;

@Name(value="editorImageActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=31)
public class ToutaticeEditorImageActionsBean
extends EditorImageActionsBean {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(EditorImageActionsBean.class);
    @In(required=false, create=true)
    protected transient DocumentsListsManager documentsListsManager;
    private static final String SEARCH_QUERY = "SELECT * FROM Document WHERE %s";
    private static final String MEDIALIB = "MediaLibrary";
    @In(create=true, required=false)
    private transient CoreSession documentManager;
    private List<DocumentModel> resultDocuments;
    private boolean hasSearchResults = false;
    private static final int SEARCH_IN_MEDIA = 0;
    private static final int SEARCH_IN_SPACE = 1;
    private static final int SEARCH_IN_ALL_NUXEO = 2;
    private int searchInSpace = 0;
    private String selectedSize = "Medium";
    private String imageUrlAttr;
    private boolean isImageUploadedAttr = false;
    private boolean isImage = true;
    @RequestParameter
    private String selectedTab;
    private String oldSelectedTab;
    private DocumentModel mediaSpace;

    public String getImageUrlAttr() {
        return this.imageUrlAttr;
    }

    public void setImageUrlAttr(String imageUrlAttr) {
        this.imageUrlAttr = imageUrlAttr;
    }

    public boolean isImageUploadedAttr() {
        return this.isImageUploadedAttr;
    }

    public void setImageUploadedAttr(boolean isImageUploadedAttr) {
        this.isImageUploadedAttr = isImageUploadedAttr;
    }

    public String getUrlForImage() {
        super.getUrlForImage();
        this.isImageUploadedAttr = false;
        return this.imageUrlAttr;
    }

    public boolean getIsImageUploaded() {
        return this.isImageUploadedAttr;
    }

    private DocumentModel getMediaSpace() throws ClientException {
        DocumentModel currentDomain = this.navigationContext.getCurrentDomain();
        String searchMediaLibraries = "ecm:primaryType = 'MediaLibrary' and ecm:path startswith '" + currentDomain.getPathAsString() + "' and ecm:isCheckedInVersion = 0 AND ecm:isProxy = 0 AND ecm:currentLifeCycleState!='deleted'";
        String queryMediaLibraries = String.format(SEARCH_QUERY, searchMediaLibraries);
        DocumentModelList query = this.documentManager.query(queryMediaLibraries);
        this.mediaSpace = query.size() < 1 || query.size() > 1 ? null : (DocumentModel)query.get(0);
        return this.mediaSpace;
    }

    public String getMediaSpaceName() throws ClientException {
        if (this.getMediaSpace() != null) {
            return this.getMediaSpace().getTitle();
        }
        return null;
    }

    public String getSpaceName() throws ClientException {
        DocumentModel space = this.navigationContext.getCurrentSuperSpace();
        if (null != space) {
            return space.getTitle();
        }
        this.searchInSpace = 2;
        return null;
    }

    public int getSearchInSpace() throws ClientException {
        if (this.searchInSpace == 0 && this.getMediaSpace() == null) {
            this.searchInSpace = 1;
        }
        return this.searchInSpace;
    }

    public void setSearchInSpace(int searchInSpace) {
        this.searchInSpace = searchInSpace;
    }

    public boolean getInToutaticeCreationMode() {
        DocumentModel doc = this.navigationContext.getChangeableDocument();
        if (doc == null) {
            doc = this.navigationContext.getCurrentDocument();
        }
        if (doc == null) {
            return false;
        }
        if (doc.getId() == null) {
            return true;
        }
        return !doc.hasSchema("toutatice");
    }

    public String searchImages() throws ClientException {
        String searchKeywords = this.getSearchKeywords();
        log.debug((Object)("Entering searchDocuments with keywords: " + searchKeywords));
        this.resultDocuments = null;
        ArrayList<String> constraints = new ArrayList<String>();
        if (searchKeywords != null && (searchKeywords = searchKeywords.trim()).length() > 0 && !searchKeywords.equals("*")) {
            constraints.add(String.format("ecm:fulltext LIKE '%s'", searchKeywords));
        }
        if (this.searchInSpace == 0 && this.getMediaSpace() != null) {
            constraints.add("ecm:path STARTSWITH '" + this.getMediaSpace().getPathAsString().replace("'", "\\'") + "'");
        } else if (this.searchInSpace == 1) {
            constraints.add("ecm:path STARTSWITH '" + this.navigationContext.getCurrentSuperSpace().getPathAsString().replace("'", "\\'") + "'");
        }
        constraints.add("ecm:primaryType = 'Picture'");
        constraints.add("ecm:isCheckedInVersion = 0 AND ecm:isProxy = 0 AND ecm:currentLifeCycleState!='deleted'");
        String query = String.format(SEARCH_QUERY, StringUtils.join(constraints, (String)" AND "));
        this.resultDocuments = this.documentManager.query(query, 100);
        this.hasSearchResults = !this.resultDocuments.isEmpty();
        log.debug((Object)("query result contains: " + this.resultDocuments.size() + " docs."));
        return "editor_image_upload";
    }

    public boolean getHasSearchResults() {
        return this.hasSearchResults;
    }

    public List<DocumentModel> getSearchImageResults() {
        return this.resultDocuments;
    }

    public String getSelectedSize() {
        return this.selectedSize;
    }

    public void setSelectedSize(String selectedSize) {
        this.selectedSize = selectedSize;
    }

    public String getSelectedTab() {
        if (this.selectedTab != null) {
            this.oldSelectedTab = this.selectedTab;
        } else if (this.oldSelectedTab == null) {
            this.oldSelectedTab = "SEARCH";
        }
        return this.oldSelectedTab;
    }

    public boolean getIsImage() {
        return this.isImage;
    }

    public String uploadImage() throws ClientException {
        InputStream uploadedImage = this.getUploadedImage();
        String uploadedImageName = this.getUploadedImageName();
        if (uploadedImage == null || uploadedImageName == null) {
            return "";
        }
        DocumentModel doc = this.navigationContext.getCurrentDocument();
        uploadedImageName = FileUtils.getCleanFileName((String)uploadedImageName);
        Blob uploadedImageBlob = FileUtils.createSerializableBlob((InputStream)uploadedImage, (String)uploadedImageName, null);
        boolean isImage = ToutaticeFileHelper.instance().isImageTypeFile(uploadedImageName, uploadedImageBlob);
        if (isImage) {
            List files = (List)((Object)doc.getPropertyValue("ttc:images"));
            HashMap<String, String> item = new HashMap<String, String>();
            item.put("filename", uploadedImageName);
            item.put("file", (String)uploadedImageBlob);
            ToutaticeImageCollectionHelper.instance().add(files, item);
            doc.setPropertyValue("ttc:images", (Serializable)((Object)files));
            this.documentManager.saveDocument(doc);
            this.documentManager.save();
            this.imageUrlAttr = DocumentModelFunctions.complexFileUrl((String)"downloadFile", (DocumentModel)doc, (String)"ttc:images", (int)files.indexOf(item), (String)"file", (String)uploadedImageName);
            this.isImageUploadedAttr = true;
        } else {
            this.isImage = false;
        }
        return "editor_image_upload";
    }

    public String addImageFromNuxeo() throws ClientException {
        DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
        List selectedDocumentList = this.documentsListsManager.getWorkingList("CURRENT_SELECTION");
        if (null != selectedDocumentList && 0 < selectedDocumentList.size()) {
            List files = (List)((Object)currentDoc.getPropertyValue("ttc:images"));
            block0: for (DocumentModel selectedDocument : selectedDocumentList) {
                Map picture = selectedDocument.getProperties("picture");
                List views = (List)picture.get("views");
                for (Map view : views) {
                    if (!"original".equalsIgnoreCase((String)view.get("tag"))) continue;
                    Blob blob = (Blob)view.get("content");
                    HashMap<String, Object> fileMap = new HashMap<String, Object>(2);
                    fileMap.put("file", blob);
                    fileMap.put("filename", selectedDocument.getTitle());
                    if (files.contains(fileMap)) continue block0;
                    ToutaticeImageCollectionHelper.instance().add(files, fileMap);
                    continue block0;
                }
            }
            this.documentsListsManager.resetWorkingList("CURRENT_SELECTION");
            currentDoc.setPropertyValue("ttc:images", (Serializable)((Object)files));
            this.documentManager.saveDocument(currentDoc);
            this.documentManager.save();
        }
        return "";
    }
}

