/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation;

import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentSecurityException;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.model.NoSuchDocumentException;

@Operation(id="Document.FetchPublishSpace", category="Fetch", label="Fetch the plubish space", description="Find among the parents list the publish space document. Return the parent publish space document or null if no-one is found or if this one is not online")
public class FetchPublishSpace {
    public static final String ID = "Document.FetchPublishSpace";
    private static final Log log = LogFactory.getLog(FetchPublishSpace.class);
    @Context
    protected CoreSession coreSession;
    @Param(name="value", required=true)
    protected DocumentModel value;

    @OperationMethod
    public Object run() throws Exception {
        DocumentModel publishSpaceDoc = null;
        if (null != this.value) {
            PublishSpaceDocumentFilter filter = new PublishSpaceDocumentFilter();
            if (filter.accept(this.value)) {
                publishSpaceDoc = this.value;
            } else {
                DocumentModelList parentList = ToutaticeDocumentHelper.getParentList((CoreSession)this.coreSession, (DocumentModel)this.value, (Filter)filter, (boolean)true);
                if (null != parentList && parentList.size() > 0) {
                    publishSpaceDoc = (DocumentModel)parentList.get(0);
                    if (!this.coreSession.hasPermission(publishSpaceDoc.getRef(), "Read")) {
                        throw new DocumentSecurityException("");
                    }
                } else {
                    throw new NoSuchDocumentException(this.value.getPathAsString());
                }
            }
        }
        return publishSpaceDoc;
    }

    private class PublishSpaceDocumentFilter
    implements Filter {
        private static final long serialVersionUID = 3207718135474475149L;

        private PublishSpaceDocumentFilter() {
        }

        public boolean accept(DocumentModel document) {
            boolean status = false;
            try {
                status = document.hasFacet("TTCPublishSpace");
                if (status) {
                    status = null != ToutaticeDocumentHelper.getProxy((CoreSession)FetchPublishSpace.this.coreSession, (DocumentModel)document, null);
                }
            }
            catch (Exception e) {
                log.error((Object)("Failed to filter the publish space document, error: " + e.getMessage()));
                status = false;
            }
            return status;
        }
    }
}

