/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation;

import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.model.NoSuchDocumentException;

@Operation(id="Document.FetchPublished", category="Fetch", label="PublishedDocument", description="Fetch the published document from the repository given its reference (path or UID). Find the proxy document associated with the document passed as parameter 'value'. If the document is not published (no proxy exists) 404 http value (not found) is returned. The document will become the input of the next operation.")
public class FetchPublishedDocument {
    public static final String ID = "Document.FetchPublished";
    private static final Log log = LogFactory.getLog(FetchPublishedDocument.class);
    @Context
    protected CoreSession session;
    @Param(name="value", required=true)
    protected DocumentModel value;

    @OperationMethod
    public DocumentModel run() throws Exception {
        DocumentModel publishedDocument = ToutaticeDocumentHelper.getProxy((CoreSession)this.session, (DocumentModel)this.value, (String)"Read");
        if (null == publishedDocument) {
            throw new NoSuchDocumentException(this.value.getPathAsString());
        }
        return publishedDocument;
    }
}

