/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jboss.seam.core.Events;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.jbpm.JbpmListFilter;
import org.nuxeo.ecm.platform.jbpm.JbpmOperation;
import org.nuxeo.ecm.platform.jbpm.JbpmService;
import org.nuxeo.ecm.platform.jbpm.NuxeoJbpmException;
import org.nuxeo.ecm.platform.jbpm.TaskListFilter;
import org.nuxeo.ecm.platform.jbpm.VirtualTaskInstance;
import org.nuxeo.ecm.platform.jbpm.operations.GetRecipientsForTaskOperation;

@Operation(id="Workflow.OperateProcess", category="Services", label="Operate an action on the process", since="5.3.2", description="Permit to operate an action (validate, reject) on the process bound to the document.")
public class OperateWFProcess {
    public static final String ID = "Workflow.OperateProcess";
    @Context
    protected OperationContext ctx;
    @Context
    protected CoreSession coreSession;
    @Context
    protected transient JbpmService jbpmService;
    @Param(name="task name", required=true, order=0)
    protected String taskName;
    @Param(name="transition", required=false, order=1)
    protected String transition;
    @Param(name="event", required=false, order=2)
    protected String event;
    @Param(name="comment", required=false, order=3)
    protected String comment;
    protected ProcessInstance currentProcess;
    protected ArrayList<VirtualTaskInstance> currentVirtualTasks;

    @OperationMethod
    public DocumentModel run(DocumentModel document) throws Exception {
        Principal principal = this.coreSession.getPrincipal();
        if (!(principal instanceof NuxeoPrincipal)) {
            throw new OperationException("Principal is not an instance of NuxeoPrincipal");
        }
        NuxeoPrincipal nuxpal = (NuxeoPrincipal)principal;
        TaskInstance taskInstance = this.getCurrentTasks(document, nuxpal, this.taskName);
        if (null != taskInstance) {
            HashMap<String, Boolean> taskVariables = new HashMap<String, Boolean>();
            taskVariables.put(JbpmService.TaskVariableName.validated.name(), Boolean.TRUE);
            this.jbpmService.endTask(Long.valueOf(taskInstance.getId()), StringUtils.isBlank((String)this.transition) ? null : this.transition, taskVariables, null, this.getTransientVariables(document, nuxpal), nuxpal);
            this.coreSession.save();
            if (StringUtils.isNotBlank((String)this.event)) {
                Set<String> recipients = this.getRecipientsFromTask(taskInstance);
                this.jbpmService.notifyEventListeners(this.event, StringUtils.isBlank((String)this.comment) ? " " : this.comment, recipients.toArray(new String[0]), this.coreSession, nuxpal, document);
                Events.instance().raiseEvent(this.event, new Object[0]);
            }
        }
        return document;
    }

    public ProcessInstance getCurrentProcess(DocumentModel document, NuxeoPrincipal principal) throws ClientException {
        List processes;
        if (this.currentProcess == null && (processes = this.jbpmService.getProcessInstances(document, principal, null)) != null && !processes.isEmpty()) {
            this.currentProcess = (ProcessInstance)processes.get(0);
        }
        return this.currentProcess;
    }

    public TaskInstance getCurrentTasks(DocumentModel document, NuxeoPrincipal principal, String taskName) throws ClientException {
        TaskInstance currentTask = null;
        ArrayList currentTasks = new ArrayList();
        ProcessInstance currentProcess = this.getCurrentProcess(document, principal);
        if (currentProcess != null) {
            currentTasks.addAll(this.jbpmService.getTaskInstances(Long.valueOf(currentProcess.getId()), null, (JbpmListFilter)new TaskListFilter(new String[]{taskName})));
        }
        if (0 < currentTasks.size()) {
            currentTask = (TaskInstance)currentTasks.get(currentTasks.size() - 1);
        }
        return currentTask;
    }

    protected Map<String, Serializable> getTransientVariables(DocumentModel document, NuxeoPrincipal principal) {
        HashMap<String, Serializable> transientVariables = new HashMap<String, Serializable>();
        transientVariables.put(JbpmService.VariableName.document.name(), (Serializable)document);
        transientVariables.put(JbpmService.VariableName.principal.name(), (Serializable)principal);
        return transientVariables;
    }

    protected Set<String> getRecipientsFromTask(TaskInstance taskInstance) throws NuxeoJbpmException {
        GetRecipientsForTaskOperation operation = new GetRecipientsForTaskOperation(taskInstance.getId());
        return (Set)((Object)this.jbpmService.executeJbpmOperation((JbpmOperation)operation));
    }
}

