/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation;

import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationNotFoundException;
import org.nuxeo.ecm.automation.OperationType;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.impl.InvokableMethod;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.DocumentSecurityException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.api.model.impl.primitives.BooleanProperty;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.Access;
import org.nuxeo.ecm.core.model.NoSuchDocumentException;
import org.nuxeo.ecm.core.trash.TrashService;
import org.nuxeo.ecm.platform.types.Type;
import org.nuxeo.ecm.platform.types.TypeManager;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Document.FetchPublicationInfos", category="Fetch", label="Fetch publish space informations", description="Fetch informations about the publish space, worksapce, proxy status, ... of a given document.")
public class FetchPublicationInfos {
    private static final Log log = LogFactory.getLog(FetchPublicationInfos.class);
    public static final String ID = "Document.FetchPublicationInfos";
    public static final int ERROR_CONTENT_NOT_FOUND = 1;
    public static final int ERROR_CONTENT_FORBIDDEN = 2;
    public static final int ERROR_PUBLISH_SPACE_NOT_FOUND = 3;
    public static final int ERROR_PUBLISH_SPACE_FORBIDDEN = 4;
    public static final int ERROR_WORKSPACE_NOT_FOUND = 5;
    public static final int ERROR_WORKSPACE_FORBIDDEN = 6;
    public static final int SERVER_ERROR = 500;
    public static final String INTERNAL_PROCESSING_ERROR_RESPONSE = "InternalProcessingErrorResponse";
    private static final String TOUTATICE_PUBLI_SUFFIX = ".proxy";
    private static final String SUFFIXE_PROXY = ".proxy";
    private static final String IN_CONTEXTUALIZATON_PROPERTY = "ttc:contextualizeInternalContents";
    @Context
    protected CoreSession coreSession;
    @Context
    protected TypeManager typeService;
    @Context
    protected UserManager userManager;
    @Param(name="path", required=true)
    protected DocumentModel document;

    @OperationMethod
    public Object run() throws Exception {
        boolean canAddChildren;
        JSONArray rowInfosPubli = new JSONArray();
        JSONObject infosPubli = new JSONObject();
        List<Integer> errorsCodes = new ArrayList<Integer>();
        DocumentRef docRef = this.document.getRef();
        Object fetchDocumentRes = this.getDocument(docRef);
        if (FetchPublicationInfos.isError(fetchDocumentRes)) {
            errorsCodes.add((Integer)fetchDocumentRes);
            infosPubli.element("errorCodes", errorsCodes);
            rowInfosPubli.add((Object)infosPubli);
            return this.createBlob(rowInfosPubli);
        }
        DocumentModel document = (DocumentModel)fetchDocumentRes;
        Object liveDocRes = this.getLiveDoc(this.coreSession, document, infosPubli);
        if (FetchPublicationInfos.isError(liveDocRes)) {
            infosPubli = (JSONObject)liveDocRes;
            infosPubli.element("documentPath", (Object)URLEncoder.encode(document.getPath().toString(), "UTF-8"));
            infosPubli.element("liveId", (Object)"");
            infosPubli.element("editableByUser", (Object)Boolean.FALSE);
            infosPubli.element("isDeletableByUser", (Object)Boolean.FALSE);
        } else {
            String docPath;
            DocumentModel liveDoc = (DocumentModel)liveDocRes;
            infosPubli.element("liveId", (Object)liveDoc.getId());
            Object isEditable = this.isEditableByUser(infosPubli, liveDoc);
            infosPubli.element("editableByUser", isEditable);
            Object isDeletable = this.isDeletableByUser(infosPubli, liveDoc);
            infosPubli.element("isDeletableByUser", isDeletable);
            String livePath = liveDoc.getPathAsString();
            String path = docPath = document.getPath().toString();
            if (docPath.endsWith(".proxy") && docPath.equals(livePath + ".proxy")) {
                path = livePath;
            }
            infosPubli.element("documentPath", (Object)URLEncoder.encode(path, "UTF-8"));
        }
        infosPubli.put((Object)"subTypes", (Object)new JSONObject());
        if (document.isFolder() && (canAddChildren = this.coreSession.hasPermission(document.getRef(), "AddChildren"))) {
            Collection allowedSubTypes = this.typeService.getAllowedSubTypes(document.getType());
            JSONObject subTypes = new JSONObject();
            for (Type subType : allowedSubTypes) {
                subTypes.put((Object)subType.getId(), (Object)URLEncoder.encode(subType.getLabel(), "UTF-8"));
            }
            infosPubli.put((Object)"subTypes", (Object)subTypes);
        }
        boolean docCommentable = document.hasFacet("Commentable");
        Principal user = this.coreSession.getPrincipal();
        if (user == null) {
            throw new ClientException("Current user not found.");
        }
        boolean userNotAnonymous = !((NuxeoPrincipal)user).isAnonymous();
        infosPubli.put((Object)"isCommentableByUser", (Object)(docCommentable && userNotAnonymous ? 1 : 0));
        UnrestrictedFecthPubliInfosRunner infosPubliRunner = new UnrestrictedFecthPubliInfosRunner(this.coreSession, document, infosPubli, this.userManager, errorsCodes);
        infosPubliRunner.runUnrestricted();
        errorsCodes = infosPubliRunner.getErrorsCodes();
        infosPubli = infosPubliRunner.getInfosPubli();
        infosPubli.element("errorCodes", errorsCodes);
        rowInfosPubli.add((Object)infosPubli);
        return this.createBlob(rowInfosPubli);
    }

    private static int getErrorCode(Exception inputException, int errorCodeNotFound, int errorCodeForbidden) {
        Exception exception = inputException;
        int errorCode = 0;
        if (exception instanceof NoSuchDocumentException) {
            errorCode = errorCodeNotFound;
        } else if (exception instanceof DocumentSecurityException) {
            errorCode = errorCodeForbidden;
        }
        return errorCode;
    }

    private Object isEditableByUser(JSONObject infos, DocumentModel liveDoc) throws ServeurException {
        Boolean canModify = null;
        try {
            canModify = this.coreSession.hasPermission(liveDoc.getRef(), "Write");
        }
        catch (ClientException e) {
            if (e instanceof DocumentSecurityException) {
                return Boolean.FALSE;
            }
            log.warn((Object)("Failed to fetch permissions for document '" + liveDoc.getPathAsString() + "', error:" + e.getMessage()));
            throw new ServeurException((Exception)((Object)e));
        }
        return canModify;
    }

    private Object isDeletableByUser(JSONObject infos, DocumentModel liveDoc) throws Exception {
        Boolean canBeDelete = Boolean.FALSE;
        try {
            TrashService trash = (TrashService)Framework.getService(TrashService.class);
            ArrayList<DocumentModel> docs = new ArrayList<DocumentModel>();
            docs.add(liveDoc);
            canBeDelete = trash.canDelete(docs, this.coreSession.getPrincipal(), false);
            if (canBeDelete.booleanValue()) {
                DocumentModel proxy = ToutaticeDocumentHelper.getProxy((CoreSession)this.coreSession, (DocumentModel)liveDoc, null);
                boolean hasProxy = null != proxy;
                boolean isApproved = "approved".equals(liveDoc.getCurrentLifeCycleState());
                if (isApproved || hasProxy) {
                    boolean canValidate = this.coreSession.hasPermission(liveDoc.getRef(), "validationWorkflow_validation");
                    canBeDelete = canValidate;
                }
            }
        }
        catch (ClientException e) {
            if (e instanceof DocumentSecurityException) {
                return Boolean.FALSE;
            }
            log.warn((Object)("Failed to fetch permissions for document '" + liveDoc.getPathAsString() + "', error:" + e.getMessage()));
            throw new ServeurException((Exception)((Object)e));
        }
        return canBeDelete;
    }

    private Object getLiveDoc(CoreSession session, DocumentModel doc, JSONObject infos) throws ServeurException {
        DocumentModel liveDoc = null;
        try {
            DocumentModel srcDocument = session.getSourceDocument(doc.getRef());
            if (session.hasPermission(srcDocument.getRef(), "ReadVersion")) {
                liveDoc = session.getWorkingCopy(srcDocument.getRef());
            }
        }
        catch (ClientException ce) {
            if (ce instanceof DocumentSecurityException) {
                infos.element("editableByUser", (Object)Boolean.FALSE);
                return infos;
            }
            log.warn((Object)("Failed to fetch live document of document'" + doc.getPathAsString() + "', error:" + ce.getMessage()));
            throw new ServeurException((Exception)((Object)ce));
        }
        if (liveDoc == null) {
            infos.element("editableByUser", (Object)Boolean.FALSE);
            return infos;
        }
        return liveDoc;
    }

    private Object getDocument(DocumentRef refDoc) throws ServeurException {
        DocumentModel doc = null;
        try {
            doc = this.coreSession.getDocument(refDoc);
        }
        catch (ClientException ce) {
            if (ce instanceof DocumentSecurityException) {
                return 2;
            }
            if (this.isNoSuchDocumentException(ce)) {
                return 1;
            }
            log.warn((Object)("Failed to fetch document with path or uid: '" + this.document + "', error:" + ce.getMessage()));
            throw new ServeurException((Exception)((Object)ce));
        }
        if (doc == null) {
            return 1;
        }
        return doc;
    }

    private boolean isNoSuchDocumentException(ClientException ce) {
        Throwable causeExc = ce.getCause();
        return causeExc instanceof NoSuchDocumentException;
    }

    private Blob createBlob(JSONArray json) {
        return new StringBlob(json.toString(), "application/json");
    }

    public static String computeNavPath(String path) {
        String result = path;
        if (path.endsWith(".proxy")) {
            result = result.substring(0, result.length() - ".proxy".length());
        }
        return result;
    }

    private static boolean isError(Object operationRes) {
        return !(operationRes instanceof DocumentModel) && !(operationRes instanceof Boolean);
    }

    private static String safeString(String value) {
        String safeValue = value;
        if (value == null) {
            safeValue = "";
        }
        return safeValue;
    }

    private static class UnrestrictedFecthPubliInfosRunner
    extends UnrestrictedSessionRunner {
        private DocumentModel document;
        private JSONObject infosPubli;
        private List<Integer> errorsCodes;
        private UserManager userManager;

        public JSONObject getInfosPubli() {
            return this.infosPubli;
        }

        public List<Integer> getErrorsCodes() {
            return this.errorsCodes;
        }

        public UnrestrictedFecthPubliInfosRunner(CoreSession session, DocumentModel document, JSONObject infosPubli, UserManager userManager, List<Integer> errorsCodes) {
            super(session);
            this.document = document;
            this.infosPubli = infosPubli;
            this.errorsCodes = errorsCodes;
            this.userManager = userManager;
        }

        public void run() throws ClientException {
            try {
                this.infosPubli.put((Object)"spaceID", (Object)this.getSpaceID(this.document));
                String parentSpaceID = "";
                DocumentModelList spaceParentList = ToutaticeDocumentHelper.getParentSpaceList((CoreSession)this.session, (DocumentModel)this.document, (boolean)true, (boolean)true);
                if (spaceParentList != null && spaceParentList.size() > 0) {
                    DocumentModel parentSpace = (DocumentModel)spaceParentList.get(0);
                    parentSpaceID = this.getSpaceID(parentSpace);
                }
                this.infosPubli.put((Object)"parentSpaceID", (Object)parentSpaceID);
                AutomationService automation = null;
                try {
                    automation = (AutomationService)Framework.getService(AutomationService.class);
                }
                catch (Exception e) {
                    log.warn((Object)("Error getting automation service, error: " + e.getMessage()));
                    throw new ServeurException(e);
                }
                OperationContext ctx = new OperationContext(this.session);
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("value", this.document);
                Object fetchPublishSpaceRes = null;
                try {
                    fetchPublishSpaceRes = this.callOperation(automation, ctx, "Document.FetchPublishSpace", parameters);
                    DocumentModel publishSpaceDoc = (DocumentModel)fetchPublishSpaceRes;
                    this.infosPubli.element("publishSpaceType", (Object)publishSpaceDoc.getType());
                    this.infosPubli.element("publishSpacePath", (Object)URLEncoder.encode(FetchPublicationInfos.computeNavPath(publishSpaceDoc.getPathAsString()), "UTF-8"));
                    try {
                        this.infosPubli.element("publishSpaceDisplayName", (Object)URLEncoder.encode(publishSpaceDoc.getTitle(), "UTF-8"));
                        BooleanProperty property = this.getInContextualizationProperty(publishSpaceDoc);
                        this.infosPubli.element("publishSpaceInContextualization", (Object)property.getValue());
                    }
                    catch (ClientException e) {
                        this.infosPubli.element("publishSpaceInContextualization", (Object)Boolean.FALSE);
                        this.errorsCodes = this.manageException(this.errorsCodes, publishSpaceDoc, e, 4, "fetch publish space name or contextualization property for space ");
                    }
                }
                catch (Exception e) {
                    this.errorsCodes.add(FetchPublicationInfos.getErrorCode(e, 3, 4));
                    this.infosPubli.element("publishSpaceInContextualization", (Object)Boolean.FALSE);
                    this.infosPubli.element("publishSpaceType", (Object)"");
                    this.infosPubli.element("publishSpacePath", (Object)"");
                    this.infosPubli.element("publishSpaceDisplayName", (Object)"");
                }
                parameters.clear();
                parameters.put("document", this.document);
                Object workspaceRes = null;
                try {
                    workspaceRes = this.callOperation(automation, ctx, "Document.FetchWorkspaceOfDocument", parameters);
                    DocumentModel workspace = (DocumentModel)workspaceRes;
                    this.infosPubli.element("workspacePath", (Object)URLEncoder.encode(workspace.getPathAsString(), "UTF-8"));
                    try {
                        this.infosPubli.element("workspaceDisplayName", (Object)URLEncoder.encode(workspace.getTitle(), "UTF-8"));
                    }
                    catch (ClientException e) {
                        this.errorsCodes = this.manageException(this.errorsCodes, workspace, e, 6, "fetch workspace name or contextualization property for workspace");
                    }
                }
                catch (Exception e) {
                    this.infosPubli.element("workspaceInContextualization", (Object)Boolean.FALSE);
                    this.infosPubli.element("workspacePath", (Object)"");
                    this.infosPubli.element("workspaceDisplayName", (Object)"");
                    this.errorsCodes.add(FetchPublicationInfos.getErrorCode(e, 5, 6));
                }
                this.infosPubli.element("workspaceInContextualization", (Object)Boolean.TRUE);
                parameters.clear();
                parameters.put("value", this.document);
                DocumentModel publishedDoc = null;
                try {
                    publishedDoc = (DocumentModel)this.callOperation(automation, ctx, "Document.FetchPublished", parameters);
                    this.infosPubli.element("published", (Object)Boolean.TRUE);
                }
                catch (Exception e) {
                    this.infosPubli.element("published", (Object)Boolean.FALSE);
                }
                Object isAnonymousRes = this.isAnonymous(this.session, this.userManager, this.document, this.infosPubli);
                if (FetchPublicationInfos.isError(isAnonymousRes)) {
                    this.infosPubli = (JSONObject)isAnonymousRes;
                } else {
                    this.infosPubli.element("anonymouslyReadable", isAnonymousRes);
                }
            }
            catch (Exception e) {
                throw new ClientException((Throwable)e);
            }
        }

        private Object callOperation(AutomationService automation, OperationContext ctx, String operationId, Map<String, Object> parameters) throws Exception {
            InvokableMethod operationMethod = this.getRunMethod(automation, operationId);
            Object operationRes = operationMethod.invoke(ctx, parameters);
            return operationRes;
        }

        private InvokableMethod getRunMethod(AutomationService automation, String operationId) throws SecurityException, NoSuchMethodException, OperationNotFoundException {
            OperationType opType = automation.getOperation(operationId);
            Method method = opType.getType().getMethod("run", null);
            OperationMethod anno = method.getAnnotation(OperationMethod.class);
            return new InvokableMethod(opType, method, anno);
        }

        private Object isAnonymous(CoreSession session, UserManager userManager, DocumentModel doc, JSONObject infos) throws ServeurException {
            boolean isAnonymous = false;
            try {
                ACP acp = this.document.getACP();
                String anonymousId = userManager.getAnonymousUserId();
                Access access = acp.getAccess(anonymousId, "Read");
                isAnonymous = access.toBoolean();
            }
            catch (ClientException e) {
                if (e instanceof DocumentSecurityException) {
                    infos.element("anonymouslyReadable", (Object)Boolean.FALSE);
                    return infos;
                }
                log.warn((Object)("Failed to get ACP of document '" + doc.getPathAsString() + "', error:" + e.getMessage()));
                throw new ServeurException((Exception)((Object)e));
            }
            return isAnonymous;
        }

        private BooleanProperty getInContextualizationProperty(DocumentModel doc) throws PropertyException, ClientException {
            BooleanProperty property = (BooleanProperty)doc.getProperty(FetchPublicationInfos.IN_CONTEXTUALIZATON_PROPERTY);
            return property;
        }

        private List<Integer> manageException(List<Integer> errorsCodes, DocumentModel doc, ClientException ce, int errorCode, String msg) throws ServeurException {
            if (!(ce instanceof DocumentSecurityException)) {
                log.warn((Object)("Failed" + msg + "'" + doc.getPathAsString() + "', error:" + ce.getMessage()));
                throw new ServeurException((Exception)((Object)ce));
            }
            errorsCodes.add(errorCode);
            return errorsCodes;
        }

        private String getSpaceID(DocumentModel document) {
            String spaceID = "";
            try {
                spaceID = ToutaticeDocumentHelper.isASpaceDocument((DocumentModel)document) ? document.getId() : FetchPublicationInfos.safeString((String)document.getProperty("toutatice", "spaceID"));
            }
            catch (ClientException e) {
                log.error((Object)("Failed to read the ttc:spaceID meta-data, error:" + e.getMessage()));
            }
            return spaceID;
        }
    }

    public static class ServeurException
    extends Exception {
        private static final long serialVersionUID = -2490817493963408580L;

        ServeurException() {
        }

        ServeurException(Exception e) {
            super(e);
        }
    }
}

