/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation;

import fr.toutatice.ecm.platform.core.helper.ToutaticeDirectoryMngtHelper;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.StringTokenizer;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;

@Operation(id="Document.GetVocabularies", category="Services", label="Get Vocabularies", since="5.4", description="Vocabularies are serialized using JSON and returned in a Blob.")
public class GetVocabularies {
    public static final String ID = "Document.GetVocabularies";
    private static final Log log = LogFactory.getLog(GetVocabularies.class);
    @Param(name="vocabularies", required=true)
    protected String vocabularies;
    @Param(name="locale", required=false)
    protected String locale;
    ArrayList<String> listValVoc;
    HashMap<String, ArrayList<String>> listVoc;
    ArrayList<String> indexVoc;

    @OperationMethod
    public Blob run() throws Exception {
        DocumentModelList entries = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("vocabularies:" + this.vocabularies));
            log.debug((Object)("locale:" + this.locale));
        }
        Locale localeChoisie = null;
        localeChoisie = StringUtils.isNotBlank((String)this.locale) ? new Locale(this.locale) : Locale.FRENCH;
        this.listValVoc = null;
        this.listVoc = new HashMap();
        this.indexVoc = new ArrayList();
        StringTokenizer parVocToken = new StringTokenizer(this.vocabularies, ";");
        while (parVocToken.hasMoreTokens()) {
            String voc = parVocToken.nextToken();
            this.indexVoc.add(voc);
            entries = ToutaticeDirectoryMngtHelper.instance().getEntries(voc);
            this.listValVoc = new ArrayList();
            for (DocumentModel entry : entries) {
                String localizedEntryLabel = ToutaticeDirectoryMngtHelper.instance().getDirectoryEntryLocalizedLabel(voc, entry.getId(), localeChoisie);
                this.listValVoc.add(URLEncoder.encode(entry.getTitle(), "UTF-8") + ";" + URLEncoder.encode(localizedEntryLabel, "UTF-8") + ";" + entry.getProperty("xvocabulary", "parent"));
            }
            this.listVoc.put(voc, this.listValVoc);
        }
        JSONArray rows = this.getChildren(null, 0);
        if (log.isDebugEnabled()) {
            log.debug((Object)("JSON:" + rows));
        }
        return new StringBlob(rows.toString(), "application/json");
    }

    JSONArray getChildren(String key, int i) {
        JSONArray rows = new JSONArray();
        String voc = "";
        if (i < this.indexVoc.size()) {
            voc = this.indexVoc.get(i);
            ArrayList<String> array = this.listVoc.get(voc);
            ++i;
            for (String valeur : array) {
                StringTokenizer v = new StringTokenizer(valeur, ";");
                String valkey = v.nextToken();
                String vali18n = v.nextToken();
                String valparent = v.nextToken();
                if (!valparent.equalsIgnoreCase(key) && key != null) continue;
                JSONObject obj = new JSONObject();
                obj.element("key", (Object)valkey);
                obj.element("value", (Object)vali18n);
                if (i != this.indexVoc.size()) {
                    obj.element("children", (Collection)this.getChildren(valkey, i));
                }
                rows.add((Object)obj);
            }
        }
        return rows;
    }
}

