/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation;

import fr.toutatice.ecm.platform.automation.helper.ToutaticeXPathPropertyHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.platform.picture.api.ImageInfo;
import org.nuxeo.ecm.platform.picture.api.ImagingService;
import org.nuxeo.runtime.api.Framework;

@Operation(id="ImageResize.Operation", category="Conversion", label="Image resizing operation", description="Operation to resize the images")
public class ResizeImageOperation {
    public static final String ID = "ImageResize.Operation";
    public static final Log log = LogFactory.getLog(ResizeImageOperation.class);
    private static final float ROUND_RANGE = new Float(0.05).floatValue();
    @Context
    protected ImagingService service;
    @Context
    protected CoreSession session;
    @Param(name="xpath_img_in", required=true)
    protected String xpath_img_in;
    @Param(name="xpath_img_out", required=true)
    protected String xpath_img_out;
    @Param(name="img_width", required=true)
    protected int img_width;
    @Param(name="img_heidth", required=true)
    protected int img_heidth;
    @Param(name="enlarge", required=false)
    protected boolean enlarge = false;

    @OperationMethod
    public DocumentModel run(DocumentModel doc) throws PropertyException, ClientException {
        ToutaticeXPathPropertyHelper inProperty = new ToutaticeXPathPropertyHelper(doc, this.xpath_img_in);
        if (inProperty.getValue() != null) {
            if (inProperty.isList()) {
                ArrayList<Map> out = new ArrayList<Map>();
                List images = (List)inProperty.getValue();
                for (Object image : images) {
                    Object resizedImage = this.resize(image, this.img_width, this.img_heidth, this.enlarge);
                    out.add((Map)resizedImage);
                }
                doc.setPropertyValue(this.xpath_img_out, (Serializable)out);
            } else {
                Object image = inProperty.getValue();
                Object resizedImage = this.resize(image, this.img_width, this.img_heidth, this.enlarge);
                if (null != resizedImage) {
                    doc.setPropertyValue(this.xpath_img_out, (Serializable)resizedImage);
                }
            }
        }
        return doc;
    }

    private Object resize(Object image, int img_width, int img_heidth, boolean enlarge) throws ClientException {
        int height;
        float hscale;
        ImageInfo info;
        int width;
        float wScale;
        float scale;
        String imageName = "";
        Blob imageBlob = null;
        HashMap resizedImage = image;
        if (image == null) {
            return null;
        }
        if (image instanceof Map) {
            Map imageMap = image;
            imageBlob = (Blob)imageMap.get("file");
            imageName = (String)imageMap.get("filename");
        } else if (image instanceof Blob) {
            imageBlob = (Blob)image;
        } else {
            log.debug((Object)("Param\u00e8tre d'entr\u00e9e inconsistant '" + this.xpath_img_in + "'. Doit d\u00e9signer une donn\u00e9e de type blob ou bien une donn\u00e9e complexe du type Map<String, Blob>"));
        }
        if (null != imageBlob && (this.roundToOne(scale = Math.min(wScale = (float)img_width / (float)(width = (info = this.getImageService().getImageInfo(imageBlob)).getWidth()), hscale = (float)img_heidth / (float)(height = info.getHeight()))) < 1.0f || this.roundToOne(scale) > 1.0f && enlarge)) {
            imageBlob = this.getImageService().resize(imageBlob, "jpg", (int)((float)width * scale), (int)((float)height * scale), info.getDepth());
            imageBlob.setMimeType("image/jpeg");
            if (image instanceof Map) {
                resizedImage = new HashMap();
                ((Map)resizedImage).put("filename", imageName);
                ((Map)resizedImage).put("file", imageBlob);
            } else {
                resizedImage = imageBlob;
            }
        }
        return resizedImage;
    }

    private float roundToOne(float nbr) {
        float rounded = nbr;
        if (1.0f - ROUND_RANGE < nbr && 1.0f + ROUND_RANGE > nbr) {
            rounded = 1.0f;
        }
        return rounded;
    }

    private ImagingService getImageService() throws ClientException {
        if (null == this.service) {
            try {
                this.service = (ImagingService)Framework.getService(ImagingService.class);
            }
            catch (Exception e) {
                throw new ClientException("Failed to get ImagingService, error: " + e.getMessage());
            }
        }
        return this.service;
    }
}

