/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.apidoc.filter;

import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nuxeo.apidoc.filter.BaseApiDocFilter;
import org.nuxeo.runtime.api.Framework;

public class CacheAndAuthFilter
extends BaseApiDocFilter {
    public static final DateFormat HTTP_EXPIRES_DATE_FORMAT = CacheAndAuthFilter.httpExpiresDateFormat();
    protected Boolean forceAnonymous;

    protected boolean forceAnonymous() {
        if (this.forceAnonymous == null) {
            this.forceAnonymous = Boolean.valueOf(Framework.getProperty((String)"org.nuxeo.apidoc.forceanonymous", (String)"false"));
        }
        return this.forceAnonymous;
    }

    @Override
    protected void internalDoFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        boolean activateCaching = false;
        String anonymousHeader = httpRequest.getHeader("X-NUXEO-ANONYMOUS-ACCESS");
        if ("true".equals(anonymousHeader) || this.forceAnonymous()) {
            activateCaching = true;
        } else {
            httpRequest.setAttribute("org.nuxeo.ecm.platform.ui.web.auth.anonymous.block", (Object)Boolean.TRUE);
        }
        if (activateCaching) {
            CacheAndAuthFilter.addCacheHeader(httpResponse, false, "600");
        }
        chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
    }

    private static DateFormat httpExpiresDateFormat() {
        SimpleDateFormat df = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        return df;
    }

    public static void addCacheHeader(HttpServletResponse httpResponse, boolean isPrivate, String cacheTime) {
        if (isPrivate) {
            httpResponse.addHeader("Cache-Control", "private, max-age=" + cacheTime);
        } else {
            httpResponse.addHeader("Cache-Control", "public, max-age=" + cacheTime);
        }
        Date date = new Date();
        long newDate = date.getTime() + Long.parseLong(cacheTime) * 1000L;
        date.setTime(newDate);
        httpResponse.setHeader("Expires", HTTP_EXPIRES_DATE_FORMAT.format(date));
    }
}

