/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.apidoc.browse;

import java.util.ArrayList;
import java.util.List;

public class ArtifactLabel
implements Comparable<ArtifactLabel> {
    protected final String id;
    protected String label;
    protected String simpleId;

    public ArtifactLabel(String id, String label, String simpleId) {
        this.id = id;
        this.label = label;
        if (simpleId == null) {
            simpleId = label;
        } else {
            this.simpleId = simpleId;
        }
    }

    public String getId() {
        return this.id;
    }

    public String getSimpleId() {
        return this.simpleId;
    }

    public String getLabel() {
        return this.label;
    }

    public String toString() {
        return this.label;
    }

    @Override
    public int compareTo(ArtifactLabel other) {
        return this.label.compareTo(other.label);
    }

    public static ArtifactLabel createLabelFromService(String service) {
        String[] parts = service.split("\\.");
        String label = parts[parts.length - 1];
        return new ArtifactLabel(service, label, null);
    }

    protected static String removePrefix(String name, List<String> prefixes) {
        for (String prefix : prefixes) {
            if (!name.startsWith(prefix)) continue;
            name = name.substring(prefix.length());
        }
        return name;
    }

    public static ArtifactLabel createLabelFromComponent(String component) {
        String label = component;
        ArrayList<String> prefixes = new ArrayList<String>();
        prefixes.add("org.nuxeo.ecm.platform.web.common.");
        prefixes.add("org.nuxeo.ecm.platform.ui.web.");
        prefixes.add("org.nuxeo.ecm.platform.");
        prefixes.add("org.nuxeo.ecm.core.");
        prefixes.add("org.nuxeo.ecm.");
        prefixes.add("org.nuxeo.");
        prefixes.add("webapp.");
        prefixes.add("webengine.");
        prefixes.add("api.");
        label = ArtifactLabel.removePrefix(component, prefixes);
        return new ArtifactLabel(component, label, null);
    }

    public static ArtifactLabel createLabelFromExtensionPoint(String extensionPoint) {
        String[] parts = extensionPoint.split("--");
        String component = parts[0];
        String ep = parts[1];
        String label = ep + " (" + component + ")";
        return new ArtifactLabel(extensionPoint, ep, component);
    }

    public static ArtifactLabel createLabelFromContribution(String contribution) {
        String[] parts = contribution.split("\\.");
        String label = parts[parts.length - 1];
        return new ArtifactLabel(contribution, label, null);
    }
}

