/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.apidoc.browse;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.nuxeo.apidoc.api.BundleGroup;
import org.nuxeo.apidoc.api.BundleGroupTreeHelper;
import org.nuxeo.apidoc.api.NuxeoArtifact;
import org.nuxeo.apidoc.browse.BundleWO;
import org.nuxeo.apidoc.browse.NuxeoArtifactWebObject;
import org.nuxeo.ecm.webengine.model.WebObject;

@WebObject(type="bundleGroup")
public class BundleGroupWO
extends NuxeoArtifactWebObject {
    @Override
    @GET
    @Produces(value={"text/html"})
    @Path(value="introspection")
    public Object doGet() throws Exception {
        BundleGroup group = this.getTargetBundleGroup();
        BundleGroupTreeHelper bgth = new BundleGroupTreeHelper(this.getSnapshotManager().getSnapshot(this.getDistributionId(), this.ctx.getCoreSession()));
        List tree = bgth.getBundleGroupSubTree(this.nxArtifactId);
        return this.getView("view").arg("group", (Object)group).arg("groupId", (Object)this.nxArtifactId).arg("tree", (Object)tree);
    }

    public BundleGroup getTargetBundleGroup() {
        return this.getSnapshotManager().getSnapshot(this.getDistributionId(), this.ctx.getCoreSession()).getBundleGroup(this.nxArtifactId);
    }

    @Override
    public NuxeoArtifact getNxArtifact() {
        return this.getTargetBundleGroup();
    }

    public List<BundleWO> getBundles() {
        ArrayList<BundleWO> result = new ArrayList<BundleWO>();
        BundleGroup group = this.getTargetBundleGroup();
        for (String bid : group.getBundleIds()) {
            result.add((BundleWO)this.ctx.newObject("bundle", new Object[]{bid}));
        }
        return result;
    }

    public List<BundleGroupWO> getSubGroups() {
        ArrayList<BundleGroupWO> result = new ArrayList<BundleGroupWO>();
        BundleGroup group = this.getTargetBundleGroup();
        for (BundleGroup bg : group.getSubGroups()) {
            result.add((BundleGroupWO)this.ctx.newObject("bundleGroup", new Object[]{bg.getId()}));
        }
        return result;
    }
}

