/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.apidoc.repository;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.nuxeo.apidoc.adapters.BaseNuxeoArtifactDocAdapter;
import org.nuxeo.apidoc.api.BundleGroup;
import org.nuxeo.apidoc.api.BundleInfo;
import org.nuxeo.apidoc.api.ComponentInfo;
import org.nuxeo.apidoc.api.ExtensionInfo;
import org.nuxeo.apidoc.api.ExtensionPointInfo;
import org.nuxeo.apidoc.api.OperationInfo;
import org.nuxeo.apidoc.api.QueryHelper;
import org.nuxeo.apidoc.api.SeamComponentInfo;
import org.nuxeo.apidoc.api.ServiceInfo;
import org.nuxeo.apidoc.documentation.JavaDocHelper;
import org.nuxeo.apidoc.snapshot.DistributionSnapshot;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.query.sql.NXQL;

public class RepositoryDistributionSnapshot
extends BaseNuxeoArtifactDocAdapter
implements DistributionSnapshot {
    protected JavaDocHelper jdocHelper = null;

    public static RepositoryDistributionSnapshot create(DistributionSnapshot distrib, CoreSession session, String containerPath, String label) throws ClientException {
        DocumentModel doc = session.createDocumentModel("NXDistribution");
        String name = RepositoryDistributionSnapshot.computeDocumentName(distrib.getKey());
        if (label != null) {
            name = RepositoryDistributionSnapshot.computeDocumentName(label);
        }
        String targetPath = new Path(containerPath).append(name).toString();
        boolean exist = false;
        if (session.exists((DocumentRef)new PathRef(targetPath))) {
            exist = true;
            doc = session.getDocument((DocumentRef)new PathRef(targetPath));
        }
        doc.setPathInfo(containerPath, name);
        if (label == null) {
            doc.setPropertyValue("dc:title", (Serializable)((Object)distrib.getKey()));
            doc.setPropertyValue("nxdistribution:key", (Serializable)((Object)distrib.getKey()));
            doc.setPropertyValue("nxdistribution:name", (Serializable)((Object)distrib.getName()));
            doc.setPropertyValue("nxdistribution:version", (Serializable)((Object)distrib.getVersion()));
        } else {
            doc.setPropertyValue("dc:title", (Serializable)((Object)label));
            doc.setPropertyValue("nxdistribution:key", (Serializable)((Object)(label + "-" + distrib.getVersion())));
            doc.setPropertyValue("nxdistribution:name", (Serializable)((Object)label));
            doc.setPropertyValue("nxdistribution:version", (Serializable)((Object)distrib.getVersion()));
        }
        doc = exist ? session.saveDocument(doc) : session.createDocument(doc);
        return new RepositoryDistributionSnapshot(doc);
    }

    public static List<DistributionSnapshot> readPersistentSnapshots(CoreSession session) {
        ArrayList<DistributionSnapshot> result = new ArrayList<DistributionSnapshot>();
        String query = "SELECT * FROM NXDistribution where ecm:currentLifeCycleState != 'deleted'";
        try {
            DocumentModelList docs = session.query(query);
            for (DocumentModel child : docs) {
                DistributionSnapshot ob = (DistributionSnapshot)child.getAdapter(DistributionSnapshot.class);
                if (ob == null) continue;
                result.add(ob);
            }
        }
        catch (Exception e) {
            log.error((Object)("Error while executing query " + query), (Throwable)e);
        }
        return result;
    }

    public RepositoryDistributionSnapshot(DocumentModel doc) {
        super(doc);
    }

    protected <T> List<T> getChildren(Class<T> adapter, String docType) {
        ArrayList<Object> result = new ArrayList<Object>();
        String query = QueryHelper.select(docType, this.doc);
        try {
            DocumentModelList docs = this.getCoreSession().query(query);
            for (DocumentModel child : docs) {
                Object ob = child.getAdapter(adapter);
                if (ob == null) continue;
                result.add(ob);
            }
        }
        catch (Exception e) {
            log.error((Object)("Error while executing query " + query), (Throwable)e);
        }
        return result;
    }

    protected <T> T getChild(Class<T> adapter, String docType, String idField, String id) {
        String query = QueryHelper.select(docType, this.doc) + " AND " + idField + " = " + NXQL.escapeString((String)id);
        try {
            DocumentModelList docs = this.getCoreSession().query(query);
            if (!docs.isEmpty()) {
                if (docs.size() == 1) {
                    return (T)((DocumentModel)docs.get(0)).getAdapter(adapter);
                }
                log.error((Object)("multiple match for " + docType + " for id " + id));
                return (T)((DocumentModel)docs.get(0)).getAdapter(adapter);
            }
            log.error((Object)("Unable to find " + docType + " for id " + id));
        }
        catch (Exception e) {
            log.error((Object)("Error while executing query " + query), (Throwable)e);
        }
        return null;
    }

    @Override
    public BundleInfo getBundle(String id) {
        return this.getChild(BundleInfo.class, "NXBundle", "nxbundle:bundleId", id);
    }

    @Override
    public BundleGroup getBundleGroup(String groupId) {
        return this.getChild(BundleGroup.class, "NXBundleGroup", "nxbundlegroup:key", groupId);
    }

    protected DocumentModel getBundleContainer() {
        try {
            return this.getCoreSession().getChild(this.doc.getRef(), "Bundles");
        }
        catch (ClientException e) {
            return this.doc;
        }
    }

    @Override
    public List<BundleGroup> getBundleGroups() {
        ArrayList<BundleGroup> grps = new ArrayList<BundleGroup>();
        try {
            String query = QueryHelper.select("NXBundleGroup", this.doc, "ecm:parentId", this.getBundleContainer().getId());
            DocumentModelList docs = this.getCoreSession().query(query);
            for (DocumentModel child : docs) {
                BundleGroup bg = (BundleGroup)child.getAdapter(BundleGroup.class);
                if (bg == null) continue;
                grps.add(bg);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while getting bundle groups", (Throwable)e);
        }
        return grps;
    }

    @Override
    public List<String> getBundleIds() {
        ArrayList<String> ids = new ArrayList<String>();
        for (BundleInfo bi : this.getChildren(BundleInfo.class, "NXBundle")) {
            ids.add(bi.getId());
        }
        return ids;
    }

    @Override
    public ComponentInfo getComponent(String id) {
        return this.getChild(ComponentInfo.class, "NXComponent", "nxcomponent:componentId", id);
    }

    @Override
    public List<String> getComponentIds() {
        ArrayList<String> ids = new ArrayList<String>();
        for (ComponentInfo ci : this.getChildren(ComponentInfo.class, "NXComponent")) {
            ids.add(ci.getId());
        }
        return ids;
    }

    @Override
    public ExtensionInfo getContribution(String id) {
        return this.getChild(ExtensionInfo.class, "NXContribution", "nxcontribution:contribId", id);
    }

    @Override
    public List<String> getContributionIds() {
        ArrayList<String> ids = new ArrayList<String>();
        for (ExtensionInfo xi : this.getChildren(ExtensionInfo.class, "NXContribution")) {
            ids.add(xi.getId());
        }
        return ids;
    }

    @Override
    public List<ExtensionInfo> getContributions() {
        return this.getChildren(ExtensionInfo.class, "NXContribution");
    }

    @Override
    public ExtensionPointInfo getExtensionPoint(String id) {
        return this.getChild(ExtensionPointInfo.class, "NXExtensionPoint", "nxextensionpoint:epId", id);
    }

    @Override
    public List<String> getExtensionPointIds() {
        ArrayList<String> ids = new ArrayList<String>();
        for (ExtensionPointInfo xpi : this.getChildren(ExtensionPointInfo.class, "NXExtensionPoint")) {
            ids.add(xpi.getId());
        }
        return ids;
    }

    @Override
    public List<String> getBundleGroupChildren(String groupId) {
        BundleGroup bg = this.getChild(BundleGroup.class, "NXBundleGroup", "nxbundlegroup:key", groupId);
        return bg.getBundleIds();
    }

    public List<String> getBundleGroupIds() {
        ArrayList<String> ids = new ArrayList<String>();
        for (BundleGroup bg : this.getChildren(BundleGroup.class, "NXBundleGroup")) {
            ids.add(bg.getId());
        }
        return ids;
    }

    @Override
    public List<String> getServiceIds() {
        ArrayList<String> ids = new ArrayList<String>();
        try {
            String query = QueryHelper.select("NXComponent", this.doc);
            DocumentModelList components = this.getCoreSession().query(query);
            for (DocumentModel componentDoc : components) {
                ComponentInfo ci = (ComponentInfo)componentDoc.getAdapter(ComponentInfo.class);
                if (ci == null) continue;
                ids.addAll(ci.getServiceNames());
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while getting service ids", (Throwable)e);
        }
        return ids;
    }

    @Override
    public String getName() {
        try {
            return (String)((Object)this.doc.getPropertyValue("nxdistribution:name"));
        }
        catch (Exception e) {
            log.error((Object)"Error while reading nxdistribution:name", (Throwable)e);
            return "!unknown!";
        }
    }

    @Override
    public String getVersion() {
        try {
            return (String)((Object)this.doc.getPropertyValue("nxdistribution:version"));
        }
        catch (Exception e) {
            log.error((Object)"Error while reading nxdistribution:version", (Throwable)e);
            return "!unknown!";
        }
    }

    @Override
    public String getKey() {
        try {
            return (String)((Object)this.doc.getPropertyValue("nxdistribution:key"));
        }
        catch (Exception e) {
            log.error((Object)"Error while reading nxdistribution:key", (Throwable)e);
            return "!unknown!";
        }
    }

    @Override
    public List<Class<?>> getSpi() {
        return null;
    }

    @Override
    public String getId() {
        return this.getKey();
    }

    @Override
    public String getArtifactType() {
        return "NXDistribution";
    }

    @Override
    public ServiceInfo getService(String id) {
        String query = QueryHelper.select("NXService", this.getDoc()) + " AND " + "nxservice:className" + " = " + NXQL.escapeString((String)id);
        try {
            DocumentModelList docs = this.getCoreSession().query(query);
            if (docs.size() == 1) {
                return (ServiceInfo)((DocumentModel)docs.get(0)).getAdapter(ServiceInfo.class);
            }
            log.error((Object)"Multiple services found");
            return null;
        }
        catch (Exception e) {
            log.error((Object)"Unable to fetch NXService", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<String> getJavaComponentIds() {
        ArrayList<String> ids = new ArrayList<String>();
        for (ComponentInfo ci : this.getChildren(ComponentInfo.class, "NXComponent")) {
            if (ci.isXmlPureComponent()) continue;
            ids.add(ci.getId());
        }
        return ids;
    }

    @Override
    public List<String> getXmlComponentIds() {
        ArrayList<String> ids = new ArrayList<String>();
        for (ComponentInfo ci : this.getChildren(ComponentInfo.class, "NXComponent")) {
            if (!ci.isXmlPureComponent()) continue;
            ids.add(ci.getId());
        }
        return ids;
    }

    @Override
    public Date getCreationDate() {
        try {
            Calendar cal = (Calendar)this.getDoc().getPropertyValue("dc:created");
            return cal.getTime();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public boolean isLive() {
        return false;
    }

    @Override
    public SeamComponentInfo getSeamComponent(String id) {
        String name = id.replace("seam:", "");
        String query = QueryHelper.select("NXSeamComponent", this.getDoc()) + " AND " + "nxseam:componentName" + " = " + NXQL.escapeString((String)name);
        try {
            DocumentModelList docs = this.getCoreSession().query(query);
            return (SeamComponentInfo)((DocumentModel)docs.get(0)).getAdapter(SeamComponentInfo.class);
        }
        catch (Exception e) {
            log.error((Object)"Unable to fetch Seam Component", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<String> getSeamComponentIds() {
        ArrayList<String> result = new ArrayList<String>();
        String query = QueryHelper.select("NXSeamComponent", this.getDoc());
        try {
            DocumentModelList docs = this.getCoreSession().query(query);
            for (DocumentModel doc : docs) {
                result.add(((SeamComponentInfo)doc.getAdapter(SeamComponentInfo.class)).getId());
            }
        }
        catch (Exception e) {
            log.error((Object)"Unable to fetch NXService", (Throwable)e);
        }
        return result;
    }

    @Override
    public List<SeamComponentInfo> getSeamComponents() {
        ArrayList<SeamComponentInfo> result = new ArrayList<SeamComponentInfo>();
        String query = QueryHelper.select("NXSeamComponent", this.getDoc());
        try {
            DocumentModelList docs = this.getCoreSession().query(query);
            for (DocumentModel doc : docs) {
                result.add((SeamComponentInfo)doc.getAdapter(SeamComponentInfo.class));
            }
        }
        catch (Exception e) {
            log.error((Object)"Unable to fetch NXService", (Throwable)e);
        }
        return result;
    }

    @Override
    public boolean containsSeamComponents() {
        return this.getSeamComponentIds().size() > 0;
    }

    @Override
    public OperationInfo getOperation(String id) {
        if (id.startsWith("op:")) {
            id = id.substring("op:".length());
        }
        String query = QueryHelper.select("NXOperation", this.getDoc()) + " AND " + "nxop:name" + " = " + NXQL.escapeString((String)id);
        try {
            DocumentModelList docs = this.getCoreSession().query(query);
            return docs.size() == 0 ? null : (OperationInfo)((DocumentModel)docs.get(0)).getAdapter(OperationInfo.class);
        }
        catch (Exception e) {
            log.error((Object)"Unable to fetch Seam Component", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<OperationInfo> getOperations() {
        ArrayList<OperationInfo> result = new ArrayList<OperationInfo>();
        String query = QueryHelper.select("NXOperation", this.getDoc());
        try {
            DocumentModelList docs = this.getCoreSession().query(query);
            for (DocumentModel doc : docs) {
                result.add((OperationInfo)doc.getAdapter(OperationInfo.class));
            }
        }
        catch (Exception e) {
            log.error((Object)"Unable to query", (Throwable)e);
        }
        return result;
    }

    @Override
    public JavaDocHelper getJavaDocHelper() {
        if (this.jdocHelper == null) {
            this.jdocHelper = JavaDocHelper.getHelper(this.getName(), this.getVersion());
        }
        return this.jdocHelper;
    }

    @Override
    public void cleanPreviousArtifacts() {
        String query = QueryHelper.select("Document", this.getDoc());
        try {
            ArrayList<DocumentRef> refs = new ArrayList<DocumentRef>();
            DocumentModelList docs = this.getCoreSession().query(query);
            for (DocumentModel doc : docs) {
                refs.add(doc.getRef());
            }
            this.getCoreSession().removeDocuments(refs.toArray(new DocumentRef[1]));
        }
        catch (ClientException e) {
            log.warn((Object)"Unable to query", (Throwable)e);
        }
    }
}

