/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.apidoc.tree;

import java.util.Collection;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.nuxeo.apidoc.api.NuxeoArtifact;
import org.nuxeo.apidoc.snapshot.DistributionSnapshot;
import org.nuxeo.apidoc.tree.VirtualNode;
import org.nuxeo.ecm.webengine.model.WebContext;
import org.nuxeo.ecm.webengine.ui.tree.JSonTreeSerializer;
import org.nuxeo.ecm.webengine.ui.tree.TreeItem;

public class NuxeoArtifactSerializer
extends JSonTreeSerializer {
    protected final WebContext ctx;
    protected final DistributionSnapshot ds;

    public NuxeoArtifactSerializer(WebContext ctx, DistributionSnapshot ds) {
        this.ctx = ctx;
        this.ds = ds;
    }

    protected static boolean useEmbeddedMode(WebContext ctx) {
        return (Boolean)ctx.getProperty("embeddedMode", (Object)Boolean.FALSE);
    }

    public String getUrl(TreeItem item) {
        NuxeoArtifact obj = (NuxeoArtifact)item.getObject();
        String distId = this.ds.getKey().replace(" ", "%20");
        if (this.ds.isLive()) {
            distId = NuxeoArtifactSerializer.useEmbeddedMode(this.ctx) ? "adm" : "current";
        }
        String url = this.ctx.getRoot().getURL() + "/" + distId + "/";
        if (obj.getArtifactType().equals("NXDistribution")) {
            return url;
        }
        url = obj.getArtifactType().equals("NXBundle") ? url + "viewBundle/" : (obj.getArtifactType().equals("NXBundleGroup") ? url + "viewBundleGroup/" : (obj.getArtifactType().equals("NXComponent") ? url + "viewComponent/" : (obj.getArtifactType().equals("NXContribution") ? url + "viewContribution/" : (obj.getArtifactType().equals("NXExtensionPoint") ? url + "viewExtensionPoint/" : (obj.getArtifactType().equals("NXService") ? url + "viewService/" : null)))));
        if (url != null) {
            url = url + obj.getId();
        } else if (obj instanceof VirtualNode) {
            VirtualNode vn = (VirtualNode)obj;
            url = this.ctx.getRoot().getURL() + "/" + distId + "/viewComponent/" + vn.getComponentId() + "#" + vn.getAnchor();
        } else {
            url = "todo";
        }
        return url;
    }

    protected JSONObject item2JSON(TreeItem item, JSONArray children) {
        JSONObject json = new JSONObject();
        String[] classes = new String[]{"folder", "Folder"};
        json.element("text", (Object)item.getLabel()).element("id", (Object)item.getPath().toString()).element("href", (Object)this.getUrl(item)).element("classes", (Object)classes).element("class", (Object)classes);
        json.element("expanded", item.isExpanded());
        if (item.isContainer()) {
            if (item.isContainer()) {
                if (item.hasChildren()) {
                    json.element("children", (Collection)children);
                } else {
                    json.element("hasChildren", true);
                }
            } else {
                json.element("hasChildren", false);
            }
        }
        return json;
    }
}

