/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.apidoc.adapters;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.apidoc.api.BaseNuxeoArtifact;
import org.nuxeo.apidoc.api.NuxeoArtifact;
import org.nuxeo.common.utils.IdUtils;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;

public abstract class BaseNuxeoArtifactDocAdapter
extends BaseNuxeoArtifact {
    protected static final Log log = LogFactory.getLog(BaseNuxeoArtifactDocAdapter.class);
    protected final DocumentModel doc;
    protected static final ThreadLocal<CoreSession> localCoreSession = new ThreadLocal();

    public static void setLocalCoreSession(CoreSession session) {
        localCoreSession.set(session);
    }

    public static void releaseLocalCoreSession() {
        localCoreSession.remove();
    }

    protected BaseNuxeoArtifactDocAdapter(DocumentModel doc) {
        this.doc = doc;
    }

    protected static String computeDocumentName(String name) {
        return IdUtils.generateId((String)name, (String)"-", (boolean)true, (int)500);
    }

    protected static String getRootPath(CoreSession session, String basePath, String suffix) throws ClientException {
        PathRef rootRef = new PathRef(basePath);
        if (session.exists((DocumentRef)rootRef)) {
            Path path = new Path(basePath).append(suffix);
            rootRef = new PathRef(path.toString());
            if (session.exists((DocumentRef)rootRef)) {
                return path.toString();
            }
            DocumentModel root = session.createDocumentModel("Folder");
            root.setPathInfo(basePath, suffix);
            root = session.createDocument(root);
            return root.getPathAsString();
        }
        return null;
    }

    public int hashCode() {
        return this.doc.getId().hashCode();
    }

    public DocumentModel getDoc() {
        return this.doc;
    }

    protected CoreSession getCoreSession() {
        CoreSession session = null;
        if (this.doc != null) {
            try {
                session = this.doc.getCoreSession();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (session == null) {
            session = localCoreSession.get();
        }
        return session;
    }

    protected <T> T getParentNuxeoArtifact(Class<T> artifactClass) {
        try {
            List parents = this.getCoreSession().getParentDocuments(this.doc.getRef());
            for (DocumentModel parent : parents) {
                Object result = parent.getAdapter(artifactClass);
                if (result == null) continue;
                return (T)result;
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while getting Parent artifact", (Throwable)e);
            return null;
        }
        log.error((Object)"Parent artifact not found ");
        return null;
    }

    protected String safeGet(String xPath) {
        return this.safeGet(String.class, xPath, null);
    }

    protected String safeGet(String xPath, String defaultValue) {
        return this.safeGet(String.class, xPath, defaultValue);
    }

    protected <T> T safeGet(Class<T> typ, String xPath, Object defaultValue) {
        try {
            Serializable value = this.doc.getPropertyValue(xPath);
            return (T)value;
        }
        catch (Exception e) {
            log.error((Object)("Error while getting property " + xPath), (Throwable)e);
            if (defaultValue == null) {
                return null;
            }
            return (T)defaultValue;
        }
    }

    @Override
    public String getHierarchyPath() {
        try {
            DocumentModel doc;
            List parents = this.getCoreSession().getParentDocuments(this.doc.getRef());
            Collections.reverse(parents);
            String path = "";
            Iterator i$ = parents.iterator();
            while (i$.hasNext() && !(doc = (DocumentModel)i$.next()).getType().equals("NXDistribution")) {
                if (doc.getType().equals("Workspace")) continue;
                NuxeoArtifact item = (NuxeoArtifact)doc.getAdapter(NuxeoArtifact.class);
                path = "/" + item.getId() + path;
            }
            return path;
        }
        catch (Exception e) {
            log.error((Object)"Error while computing Hierarchy path", (Throwable)e);
            return null;
        }
    }
}

