/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.apidoc.documentation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.LinkedMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.apidoc.api.AbstractDocumentationItem;
import org.nuxeo.apidoc.api.DocumentationItem;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;

public class DocumentationItemDocAdapter
extends AbstractDocumentationItem
implements DocumentationItem {
    protected static final Log log = LogFactory.getLog(DocumentationItemDocAdapter.class);
    protected final DocumentModel doc;

    public DocumentationItemDocAdapter(DocumentModel doc) {
        this.doc = doc;
    }

    public DocumentModel getDocumentModel() {
        return this.doc;
    }

    @Override
    public List<String> getApplicableVersion() {
        try {
            return (List)((Object)this.doc.getPropertyValue("nxdoc:applicableVersions"));
        }
        catch (Exception e) {
            log.error((Object)"Error while reading applicable version", (Throwable)e);
            return new ArrayList<String>();
        }
    }

    @Override
    public String getContent() {
        String encoding = "unset";
        try {
            Blob blob = (Blob)this.doc.getPropertyValue("file:content");
            if (blob == null) {
                return "";
            }
            encoding = blob.getEncoding();
            if (encoding == null || encoding.equals("")) {
                blob.setEncoding("utf-8");
            }
            return blob.getString();
        }
        catch (Exception e) {
            log.error((Object)("Error while reading content with encoding " + encoding), (Throwable)e);
            return "ERROR : " + e.getMessage();
        }
    }

    @Override
    public String getRenderingType() {
        try {
            return (String)((Object)this.doc.getPropertyValue("nxdoc:renderingType"));
        }
        catch (Exception e) {
            log.error((Object)"Error while reading rendering type", (Throwable)e);
            return "";
        }
    }

    @Override
    public String getTarget() {
        try {
            return (String)((Object)this.doc.getPropertyValue("nxdoc:target"));
        }
        catch (Exception e) {
            log.error((Object)"Error while reading target", (Throwable)e);
            return "";
        }
    }

    @Override
    public String getTargetType() {
        try {
            return (String)((Object)this.doc.getPropertyValue("nxdoc:targetType"));
        }
        catch (Exception e) {
            log.error((Object)"Error while reading targetType", (Throwable)e);
            return "";
        }
    }

    @Override
    public String getType() {
        try {
            return (String)((Object)this.doc.getPropertyValue("nxdoc:type"));
        }
        catch (Exception e) {
            log.error((Object)"Error while reading type", (Throwable)e);
            return "";
        }
    }

    @Override
    public boolean isApproved() {
        try {
            Boolean approved = (Boolean)this.doc.getPropertyValue("nxdoc:nuxeoApproved");
            return approved == null ? false : approved;
        }
        catch (Exception e) {
            log.error((Object)"Error while reading type", (Throwable)e);
            return false;
        }
    }

    @Override
    public String getId() {
        try {
            return (String)((Object)this.doc.getPropertyValue("nxdoc:documentationId"));
        }
        catch (Exception e) {
            log.error((Object)"Error while reading target", (Throwable)e);
            return "";
        }
    }

    @Override
    public String getUUID() {
        return this.doc.getId();
    }

    @Override
    public String getTitle() {
        try {
            return (String)((Object)this.doc.getPropertyValue("dc:title"));
        }
        catch (Exception e) {
            log.error((Object)"Error while reading title", (Throwable)e);
            return "";
        }
    }

    @Override
    public Map<String, String> getAttachments() {
        LinkedMap attachments = new LinkedMap();
        try {
            List atts = (List)((Object)this.doc.getPropertyValue("files:files"));
            if (atts != null) {
                for (Map att : atts) {
                    Blob attBlob = (Blob)att.get("file");
                    if (attBlob.getEncoding() == null || attBlob.getEncoding().equals("")) {
                        attBlob.setEncoding("utf-8");
                    }
                    attachments.put((String)att.get("filename"), attBlob.getString());
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while reading Attachments", (Throwable)e);
        }
        return attachments;
    }

    @Override
    public boolean isPlaceHolder() {
        return false;
    }

    @Override
    public String getEditId() {
        return this.getUUID();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }
}

