/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.apidoc.repository;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.apidoc.adapters.BundleGroupDocAdapter;
import org.nuxeo.apidoc.adapters.BundleInfoDocAdapter;
import org.nuxeo.apidoc.adapters.ComponentInfoDocAdapter;
import org.nuxeo.apidoc.adapters.ExtensionInfoDocAdapter;
import org.nuxeo.apidoc.adapters.ExtensionPointInfoDocAdapter;
import org.nuxeo.apidoc.adapters.OperationInfoDocAdapter;
import org.nuxeo.apidoc.adapters.SeamComponentInfoDocAdapter;
import org.nuxeo.apidoc.adapters.ServiceInfoDocAdapter;
import org.nuxeo.apidoc.api.BundleGroup;
import org.nuxeo.apidoc.api.BundleInfo;
import org.nuxeo.apidoc.api.ComponentInfo;
import org.nuxeo.apidoc.api.DocumentationItem;
import org.nuxeo.apidoc.api.ExtensionInfo;
import org.nuxeo.apidoc.api.ExtensionPointInfo;
import org.nuxeo.apidoc.api.NuxeoArtifact;
import org.nuxeo.apidoc.api.OperationInfo;
import org.nuxeo.apidoc.api.SeamComponentInfo;
import org.nuxeo.apidoc.api.ServiceInfo;
import org.nuxeo.apidoc.documentation.DocumentationItemDocAdapter;
import org.nuxeo.apidoc.documentation.DocumentationService;
import org.nuxeo.apidoc.documentation.ResourceDocumentationItem;
import org.nuxeo.apidoc.introspection.BundleGroupImpl;
import org.nuxeo.apidoc.introspection.BundleInfoImpl;
import org.nuxeo.apidoc.introspection.OperationInfoImpl;
import org.nuxeo.apidoc.repository.RepositoryDistributionSnapshot;
import org.nuxeo.apidoc.snapshot.DistributionSnapshot;
import org.nuxeo.apidoc.snapshot.SnapshotFilter;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.impl.ACLImpl;
import org.nuxeo.runtime.api.Framework;

public class SnapshotPersister {
    public static final String Root_PATH = "/";
    public static final String Root_NAME = "nuxeo-distributions";
    public static final String Seam_Root_NAME = "Seam";
    public static final String Operation_Root_NAME = "Automation";
    public static final String Bundle_Root_NAME = "Bundles";
    public static final String Read_Grp = "Everyone";
    public static final String Write_Grp = "members";
    protected static final Log log = LogFactory.getLog(SnapshotPersister.class);

    public DocumentModel getSubRoot(CoreSession session, DocumentModel root, String name) throws ClientException {
        PathRef rootRef = new PathRef(root.getPathAsString() + name);
        if (session.exists((DocumentRef)rootRef)) {
            return session.getDocument((DocumentRef)rootRef);
        }
        UnrestrictedRootCreator creator = new UnrestrictedRootCreator(session, root.getPathAsString(), name, false);
        creator.runUnrestricted();
        session.save();
        return session.getDocument(creator.getRootRef());
    }

    public DocumentModel getDistributionRoot(CoreSession session) throws ClientException {
        PathRef rootRef = new PathRef("/nuxeo-distributions");
        if (session.exists((DocumentRef)rootRef)) {
            return session.getDocument((DocumentRef)rootRef);
        }
        UnrestrictedRootCreator creator = new UnrestrictedRootCreator(session, Root_PATH, Root_NAME, true);
        creator.runUnrestricted();
        session.save();
        return session.getDocument(creator.getRootRef());
    }

    public DistributionSnapshot persist(DistributionSnapshot snapshot, CoreSession session, String label, SnapshotFilter filter) throws ClientException, OperationException {
        RepositoryDistributionSnapshot distribContainer = this.createDistributionDoc(snapshot, session, label);
        if (filter == null) {
            distribContainer.cleanPreviousArtifacts();
        }
        DocumentModel bundleContainer = this.getSubRoot(session, distribContainer.getDoc(), Bundle_Root_NAME);
        if (filter != null) {
            BundleGroupImpl vGroup = new BundleGroupImpl(filter.getBundleGroupName(), snapshot.getVersion());
            for (String bundleId : snapshot.getBundleIds()) {
                if (!filter.includeBundleId(bundleId)) continue;
                vGroup.add(bundleId);
            }
            this.persistBundleGroup(snapshot, vGroup, session, label + "-bundles", bundleContainer);
        } else {
            List<BundleGroup> bundleGroups = snapshot.getBundleGroups();
            for (BundleGroup bundleGroup : bundleGroups) {
                this.persistBundleGroup(snapshot, bundleGroup, session, label, bundleContainer);
            }
        }
        DocumentModel seamContainer = this.getSubRoot(session, distribContainer.getDoc(), Seam_Root_NAME);
        this.persistSeamComponents(snapshot, snapshot.getSeamComponents(), session, label, seamContainer, filter);
        DocumentModel opContainer = this.getSubRoot(session, distribContainer.getDoc(), Operation_Root_NAME);
        this.persistOperations(snapshot, snapshot.getOperations(), session, label, opContainer, filter);
        return distribContainer;
    }

    public void persistSeamComponents(DistributionSnapshot snapshot, List<SeamComponentInfo> seamComponents, CoreSession session, String label, DocumentModel parent, SnapshotFilter filter) throws ClientException {
        for (SeamComponentInfo seamComponent : seamComponents) {
            if (filter != null && !filter.includeSeamComponent(seamComponent)) continue;
            this.persistSeamComponent(snapshot, seamComponent, session, label, parent);
        }
    }

    public void persistSeamComponent(DistributionSnapshot snapshot, SeamComponentInfo seamComponent, CoreSession session, String label, DocumentModel parent) throws ClientException {
        try {
            SeamComponentInfoDocAdapter.create(seamComponent, session, parent.getPathAsString());
        }
        catch (Exception e) {
            throw new ClientException("Errors while persisting Seam Component as document", (Throwable)e);
        }
    }

    public void persistOperations(DistributionSnapshot snapshot, List<OperationInfo> operations, CoreSession session, String label, DocumentModel parent, SnapshotFilter filter) throws ClientException {
        for (OperationInfo op : operations) {
            if (filter != null && (!(op instanceof OperationInfoImpl) || !filter.includeOperation((OperationInfoImpl)op))) continue;
            this.persistOperation(snapshot, op, session, label, parent);
        }
    }

    public void persistOperation(DistributionSnapshot snapshot, OperationInfo op, CoreSession session, String label, DocumentModel parent) throws ClientException {
        try {
            OperationInfoDocAdapter.create(op, session, parent.getPathAsString());
        }
        catch (Exception e) {
            throw new ClientException("Errors while persisting Operation as document", (Throwable)e);
        }
    }

    public void persistBundleGroup(DistributionSnapshot snapshot, BundleGroup bundleGroup, CoreSession session, String label, DocumentModel parent) throws ClientException {
        Map<String, ResourceDocumentationItem> liveDoc;
        log.info((Object)("Persist bundle group " + bundleGroup.getId()));
        DocumentModel bundleGroupDoc = this.createBundleGroupDoc(bundleGroup, session, label, parent);
        if (bundleGroup instanceof BundleGroupImpl && (liveDoc = ((BundleGroupImpl)bundleGroup).getLiveDoc()) != null && liveDoc.size() > 0) {
            this.persistLiveDoc(liveDoc, (NuxeoArtifact)bundleGroupDoc.getAdapter(BundleGroup.class), session);
        }
        for (String bundleId : bundleGroup.getBundleIds()) {
            BundleInfo bi = snapshot.getBundle(bundleId);
            this.persistBundle(snapshot, bi, session, label, bundleGroupDoc);
        }
        for (BundleGroup subGroup : bundleGroup.getSubGroups()) {
            this.persistBundleGroup(snapshot, subGroup, session, label, bundleGroupDoc);
        }
    }

    protected void persistLiveDoc(Map<String, ResourceDocumentationItem> liveDoc, NuxeoArtifact item, CoreSession session) throws ClientException {
        DocumentationService ds = (DocumentationService)Framework.getLocalService(DocumentationService.class);
        List<DocumentationItem> existingDocs = ds.findDocumentItems(session, item);
        for (String cat : liveDoc.keySet()) {
            ResourceDocumentationItem docItem = liveDoc.get(cat);
            DocumentationItem previousDocItem = null;
            for (DocumentationItem exiting : existingDocs) {
                if (!exiting.getTitle().equals(docItem.getTitle()) || !exiting.getTarget().equals(docItem.getTarget())) continue;
                previousDocItem = exiting;
                break;
            }
            if (previousDocItem == null) {
                ds.createDocumentationItem(session, item, docItem.getTitle(), docItem.getContent(), cat, Arrays.asList(item.getVersion()), docItem.isApproved(), docItem.getRenderingType());
                continue;
            }
            if (!(previousDocItem instanceof DocumentationItemDocAdapter)) continue;
            DocumentationItemDocAdapter existingDoc = (DocumentationItemDocAdapter)previousDocItem;
            StringBlob blob = new StringBlob(docItem.getContent());
            Blob oldBlob = (Blob)existingDoc.getDocumentModel().getPropertyValue("file:content");
            blob.setFilename(oldBlob.getFilename());
            existingDoc.getDocumentModel().setPropertyValue("file:content", (Serializable)blob);
            ds.updateDocumentationItem(session, existingDoc);
        }
    }

    public void persistBundle(DistributionSnapshot snapshot, BundleInfo bundleInfo, CoreSession session, String label, DocumentModel parent) throws ClientException {
        Map<String, ResourceDocumentationItem> liveDoc;
        log.info((Object)("Persist bundle " + bundleInfo.getId()));
        DocumentModel bundleDoc = this.createBundleDoc(snapshot, session, label, bundleInfo, parent);
        if (bundleInfo instanceof BundleInfoImpl && (liveDoc = ((BundleInfoImpl)bundleInfo).getLiveDoc()) != null && liveDoc.size() > 0) {
            this.persistLiveDoc(liveDoc, (NuxeoArtifact)bundleDoc.getAdapter(BundleInfo.class), session);
        }
        for (ComponentInfo ci : bundleInfo.getComponents()) {
            this.persistComponent(snapshot, ci, session, label, bundleDoc);
        }
    }

    public void persistComponent(DistributionSnapshot snapshot, ComponentInfo ci, CoreSession session, String label, DocumentModel parent) throws ClientException {
        DocumentModel componentDoc = this.createComponentDoc(snapshot, session, label, ci, parent);
        for (ExtensionPointInfo epi : ci.getExtensionPoints()) {
            this.createExtensionPointDoc(snapshot, session, label, epi, componentDoc);
        }
        for (ExtensionInfo ei : ci.getExtensions()) {
            this.createContributionDoc(snapshot, session, label, ei, componentDoc);
        }
        for (ServiceInfo si : ci.getServices()) {
            this.createServiceDoc(snapshot, session, label, si, componentDoc);
        }
    }

    protected DocumentModel createContributionDoc(DistributionSnapshot snapshot, CoreSession session, String label, ExtensionInfo ei, DocumentModel parent) throws ClientException {
        try {
            return ExtensionInfoDocAdapter.create(ei, session, parent.getPathAsString()).getDoc();
        }
        catch (Exception e) {
            throw new ClientException("Unable to create Contribution Document", (Throwable)e);
        }
    }

    protected DocumentModel createServiceDoc(DistributionSnapshot snapshot, CoreSession session, String label, ServiceInfo si, DocumentModel parent) throws ClientException {
        try {
            return ServiceInfoDocAdapter.create(si, session, parent.getPathAsString()).getDoc();
        }
        catch (Exception e) {
            throw new ClientException("Unable to create Contribution Document", (Throwable)e);
        }
    }

    protected DocumentModel createExtensionPointDoc(DistributionSnapshot snapshot, CoreSession session, String label, ExtensionPointInfo epi, DocumentModel parent) throws ClientException {
        try {
            return ExtensionPointInfoDocAdapter.create(epi, session, parent.getPathAsString()).getDoc();
        }
        catch (Exception e) {
            throw new ClientException("Unable to create ExtensionPoint Document", (Throwable)e);
        }
    }

    protected DocumentModel createComponentDoc(DistributionSnapshot snapshot, CoreSession session, String label, ComponentInfo ci, DocumentModel parent) throws ClientException {
        try {
            return ComponentInfoDocAdapter.create(ci, session, parent.getPathAsString()).getDoc();
        }
        catch (Exception e) {
            throw new ClientException("Unable to create Component Doc", (Throwable)e);
        }
    }

    protected DocumentModel createBundleDoc(DistributionSnapshot snapshot, CoreSession session, String label, BundleInfo bi, DocumentModel parent) throws ClientException {
        return BundleInfoDocAdapter.create(bi, session, parent.getPathAsString()).getDoc();
    }

    protected RepositoryDistributionSnapshot createDistributionDoc(DistributionSnapshot snapshot, CoreSession session, String label) throws ClientException {
        return RepositoryDistributionSnapshot.create(snapshot, session, this.getDistributionRoot(session).getPathAsString(), label);
    }

    protected DocumentModel createBundleGroupDoc(BundleGroup bundleGroup, CoreSession session, String label, DocumentModel parent) throws ClientException {
        return BundleGroupDocAdapter.create(bundleGroup, session, parent.getPathAsString()).getDoc();
    }

    class UnrestrictedRootCreator
    extends UnrestrictedSessionRunner {
        protected DocumentRef rootRef;
        protected final String parentPath;
        protected final String name;
        protected final boolean setAcl;

        public UnrestrictedRootCreator(CoreSession session, String parentPath, String name, boolean setAcl) {
            super(session);
            this.name = name;
            this.parentPath = parentPath;
            this.setAcl = setAcl;
        }

        public DocumentRef getRootRef() {
            return this.rootRef;
        }

        public void run() throws ClientException {
            DocumentModel root = this.session.createDocumentModel(this.parentPath, this.name, "Workspace");
            root.setProperty("dublincore", "title", (Object)this.name);
            root = this.session.createDocument(root);
            if (this.setAcl) {
                ACLImpl acl = new ACLImpl();
                acl.add((Object)new ACE(SnapshotPersister.Write_Grp, "Write", true));
                acl.add((Object)new ACE(SnapshotPersister.Read_Grp, "Read", true));
                ACP acp = root.getACP();
                acp.addACL((ACL)acl);
                this.session.setACP(root.getRef(), acp, true);
            }
            this.rootRef = root.getRef();
            this.session.save();
        }
    }
}

