/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.apidoc.export;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.nuxeo.apidoc.export.ArchiveFile;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.webengine.WebException;

@Provider
@Produces(value={"*/*", "text/plain"})
public class ArchiveFileWriter
implements MessageBodyWriter<ArchiveFile> {
    public void writeTo(ArchiveFile t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(t);
            FileUtils.copy((InputStream)in, (OutputStream)entityStream);
            entityStream.flush();
        }
        catch (Throwable e) {
            throw WebException.wrap((String)"Failed to render resource", (Throwable)e);
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (t != null) {
                t.delete();
            }
        }
    }

    public long getSize(ArchiveFile arg0, Class<?> arg1, Type arg2, Annotation[] arg3, MediaType arg4) {
        long n = arg0.length();
        return n <= 0L ? -1L : n;
    }

    public boolean isWriteable(Class<?> arg0, Type type, Annotation[] arg2, MediaType arg3) {
        return ArchiveFile.class.isAssignableFrom(arg0);
    }
}

