/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.apidoc.introspection;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.apidoc.api.ComponentInfo;
import org.nuxeo.apidoc.documentation.DocumentationHelper;
import org.nuxeo.apidoc.introspection.BundleInfoImpl;
import org.nuxeo.apidoc.introspection.ComponentInfoImpl;
import org.nuxeo.apidoc.introspection.EmbeddedDocExtractor;
import org.nuxeo.apidoc.introspection.ExtensionInfoImpl;
import org.nuxeo.apidoc.introspection.ExtensionPointInfoImpl;
import org.nuxeo.apidoc.introspection.XMLWriter;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.osgi.BundleImpl;
import org.nuxeo.runtime.RuntimeService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.Extension;
import org.nuxeo.runtime.model.ExtensionPoint;
import org.nuxeo.runtime.model.RegistrationInfo;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ServerInfo {
    private static final Log log = LogFactory.getLog(ServerInfo.class);
    public static final String META_INF_MANIFEST_MF = "META-INF/MANIFEST.MF";
    public static final String POM_XML = "pom.xml";
    public static final String POM_PROPERTIES = "pom.properties";
    protected static final DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    protected static final XPathFactory xpathFactory = XPathFactory.newInstance();
    protected final String name;
    protected final String version;
    protected final Map<String, BundleInfoImpl> bundles = new HashMap<String, BundleInfoImpl>();
    protected final List<Class<?>> allSpi = new ArrayList();

    public ServerInfo(String name, String version) {
        this.name = name;
        this.version = version;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public Collection<BundleInfoImpl> getBundles() {
        return this.bundles.values();
    }

    public void addBundle(BundleInfoImpl bundle) {
        this.bundles.put(bundle.getId(), bundle);
    }

    public void addBundle(Collection<BundleInfoImpl> bundles) {
        for (BundleInfoImpl bundle : bundles) {
            this.bundles.put(bundle.getId(), bundle);
        }
    }

    public BundleInfoImpl getBundle(String id) {
        return this.bundles.get(id);
    }

    public static ServerInfo build() {
        return ServerInfo.build(Framework.getProperty((String)"org.nuxeo.ecm.product.name", (String)"Nuxeo"), Framework.getProperty((String)"org.nuxeo.ecm.product.version", (String)"unknown"));
    }

    protected static BundleInfoImpl computeBundleInfo(Bundle bundle) {
        RuntimeService runtime = Framework.getRuntime();
        BundleInfoImpl binfo = new BundleInfoImpl(bundle.getSymbolicName());
        binfo.setFileName(runtime.getBundleFile(bundle).getName());
        binfo.setLocation(bundle.getLocation());
        if (!(bundle instanceof BundleImpl)) {
            return binfo;
        }
        BundleImpl nxBundle = (BundleImpl)bundle;
        File jarFile = nxBundle.getBundleFile().getFile();
        if (jarFile == null) {
            return binfo;
        }
        try {
            if (jarFile.isDirectory()) {
                File up;
                File pom;
                File manifest = new File(jarFile, META_INF_MANIFEST_MF);
                if (manifest.exists()) {
                    FileInputStream is = new FileInputStream(manifest);
                    String mf = FileUtils.read((InputStream)is);
                    binfo.setManifest(mf);
                }
                if (!(pom = new File(up = new File(jarFile, ".."), POM_XML)).exists() && !(pom = new File(new File(up, ".."), POM_XML)).exists()) {
                    pom = null;
                }
                if (pom != null) {
                    String version;
                    String artifactId;
                    DocumentBuilder b = documentBuilderFactory.newDocumentBuilder();
                    Document doc = b.parse(new FileInputStream(pom));
                    XPath xpath = xpathFactory.newXPath();
                    String groupId = (String)xpath.evaluate("//project/groupId", doc, XPathConstants.STRING);
                    if ("".equals(groupId)) {
                        groupId = (String)xpath.evaluate("//project/parent/groupId", doc, XPathConstants.STRING);
                    }
                    if ("".equals(artifactId = (String)xpath.evaluate("//project/artifactId", doc, XPathConstants.STRING))) {
                        artifactId = (String)xpath.evaluate("//project/parent/artifactId", doc, XPathConstants.STRING);
                    }
                    if ("".equals(version = (String)xpath.evaluate("//project/version", doc, XPathConstants.STRING))) {
                        version = (String)xpath.evaluate("//project/parent/version", doc, XPathConstants.STRING);
                    }
                    binfo.setArtifactId(artifactId);
                    binfo.setGroupId(groupId);
                    binfo.setArtifactVersion(version);
                }
            } else {
                ZipFile zFile = new ZipFile(jarFile);
                ZipEntry mfEntry = zFile.getEntry(META_INF_MANIFEST_MF);
                if (mfEntry != null) {
                    InputStream mfStream = zFile.getInputStream(mfEntry);
                    String mf = FileUtils.read((InputStream)mfStream);
                    binfo.setManifest(mf);
                }
                Enumeration<? extends ZipEntry> entries = zFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (!entry.getName().endsWith(POM_PROPERTIES)) continue;
                    InputStream is = zFile.getInputStream(entry);
                    PropertyResourceBundle prb = new PropertyResourceBundle(is);
                    String groupId = prb.getString("groupId");
                    String artifactId = prb.getString("artifactId");
                    String version = prb.getString("version");
                    binfo.setArtifactId(artifactId);
                    binfo.setGroupId(groupId);
                    binfo.setArtifactVersion(version);
                    is.close();
                    break;
                }
                zFile.close();
                zFile = new ZipFile(jarFile);
                EmbeddedDocExtractor.extractEmbeddedDoc(zFile, binfo);
                zFile.close();
            }
        }
        catch (IOException | ParserConfigurationException | XPathException | ClientException | SAXException e) {
            log.error((Object)e, e);
        }
        return binfo;
    }

    protected static List<Class<?>> getSPI(Class<?> klass) {
        ArrayList spi = new ArrayList();
        for (Field field : klass.getDeclaredFields()) {
            Class<?> fieldClass;
            Annotation[] annotations;
            String cName = field.getType().getCanonicalName();
            if (!cName.startsWith("org.nuxeo") || (annotations = (fieldClass = field.getType()).getDeclaredAnnotations()).length != 0) continue;
            spi.add(fieldClass);
        }
        return spi;
    }

    public static ServerInfo build(String name, String version) {
        Bundle[] allbundles;
        RuntimeService runtime = Framework.getRuntime();
        ServerInfo server = new ServerInfo(name, version);
        BundleInfoImpl configVirtualBundle = new BundleInfoImpl("org.nuxeo.ecm.config");
        server.addBundle(configVirtualBundle);
        HashMap<String, ExtensionPointInfoImpl> xpRegistry = new HashMap<String, ExtensionPointInfoImpl>();
        ArrayList<ExtensionInfoImpl> contribRegistry = new ArrayList<ExtensionInfoImpl>();
        Collection registrations = runtime.getComponentManager().getRegistrations();
        for (RegistrationInfo ri : registrations) {
            String cname = ri.getName().getName();
            Bundle bundle = ri.getContext().getBundle();
            BundleInfoImpl binfo = null;
            if (bundle == null) {
                binfo = configVirtualBundle;
            } else {
                String symName = bundle.getSymbolicName();
                if (symName == null) {
                    log.error((Object)("No symbolic name found for bundle " + cname));
                    continue;
                }
                binfo = server.bundles.containsKey(bundle.getSymbolicName()) ? server.bundles.get(bundle.getSymbolicName()) : ServerInfo.computeBundleInfo(bundle);
            }
            ComponentInfoImpl component = new ComponentInfoImpl(binfo, cname);
            if (ri.getExtensionPoints() != null) {
                for (ExtensionPoint extensionPoint : ri.getExtensionPoints()) {
                    ExtensionPointInfoImpl xpinfo = new ExtensionPointInfoImpl(component, extensionPoint.getName());
                    Class[] ctypes = extensionPoint.getContributions();
                    String[] descriptors = new String[ctypes.length];
                    for (int i = 0; i < ctypes.length; ++i) {
                        descriptors[i] = ctypes[i].getCanonicalName();
                        List<Class<?>> spi = ServerInfo.getSPI(ctypes[i]);
                        xpinfo.addSpi(spi);
                        server.allSpi.addAll(spi);
                    }
                    xpinfo.setDescriptors(descriptors);
                    xpinfo.setDocumentation(extensionPoint.getDocumentation());
                    xpRegistry.put(xpinfo.getId(), xpinfo);
                    component.addExtensionPoint(xpinfo);
                }
            }
            component.setXmlFileUrl(ri.getXmlFileUrl());
            if (ri.getProvidedServiceNames() != null) {
                for (String string : ri.getProvidedServiceNames()) {
                    component.addService(string);
                }
            }
            if (ri.getExtensions() != null) {
                for (Extension extension : ri.getExtensions()) {
                    ExtensionInfoImpl xtinfo = new ExtensionInfoImpl(component, extension.getExtensionPoint());
                    xtinfo.setTargetComponentName(extension.getTargetComponent());
                    xtinfo.setContribution(extension.getContributions());
                    xtinfo.setDocumentation(extension.getDocumentation());
                    xtinfo.setXml(DocumentationHelper.secureXML(extension.toXML()));
                    contribRegistry.add(xtinfo);
                    component.addExtension(xtinfo);
                }
            }
            component.setComponentClass(ri.getImplementation());
            component.setDocumentation(ri.getDocumentation());
            binfo.addComponent(component);
            server.addBundle(binfo);
        }
        for (Bundle bundle : allbundles = runtime.getContext().getBundle().getBundleContext().getBundles()) {
            if (server.bundles.containsKey(bundle.getSymbolicName())) continue;
            BundleInfoImpl bi = ServerInfo.computeBundleInfo(bundle);
            server.addBundle(bi);
        }
        for (ExtensionInfoImpl contrib : contribRegistry) {
            String xp = contrib.getExtensionPoint();
            ExtensionPointInfoImpl ep = (ExtensionPointInfoImpl)xpRegistry.get(xp);
            if (ep == null) continue;
            ep.addExtension(contrib);
        }
        return server;
    }

    public void toXML(Writer writer) throws IOException {
        XMLWriter xw = new XMLWriter(writer, 4);
        xw.start();
        xw.element("server").attr("name", (Object)this.name).attr("version", (Object)this.version).start();
        for (BundleInfoImpl bundle : this.bundles.values()) {
            xw.element("bundle").attr("id", (Object)bundle.bundleId).start();
            xw.element("fileName").content(bundle.fileName);
            for (ComponentInfo component : bundle.getComponents()) {
                xw.element("component").attr("id", (Object)component.getId()).start();
                xw.close();
            }
            xw.close();
        }
        xw.close();
        xw.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServerInfo fromXML(File file) throws IOException {
        try (FileReader reader = new FileReader(file);){
            ServerInfo serverInfo = ServerInfo.fromXML(reader);
            return serverInfo;
        }
    }

    public static ServerInfo fromXML(Reader reader) {
        return null;
    }

    public List<Class<?>> getAllSpi() {
        return this.allSpi;
    }
}

