/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.apidoc.adapters;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.dom4j.DocumentException;
import org.nuxeo.apidoc.adapters.BaseNuxeoArtifactDocAdapter;
import org.nuxeo.apidoc.api.BundleInfo;
import org.nuxeo.apidoc.api.ComponentInfo;
import org.nuxeo.apidoc.api.ExtensionInfo;
import org.nuxeo.apidoc.documentation.ContributionItem;
import org.nuxeo.apidoc.documentation.DocumentationHelper;
import org.nuxeo.apidoc.documentation.XMLContributionParser;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.runtime.model.ComponentName;

public class ExtensionInfoDocAdapter
extends BaseNuxeoArtifactDocAdapter
implements ExtensionInfo {
    public static ExtensionInfoDocAdapter create(ExtensionInfo xi, CoreSession session, String containerPath) throws ClientException {
        DocumentModel doc = session.createDocumentModel("NXContribution");
        String name = ExtensionInfoDocAdapter.computeDocumentName("contrib-" + xi.getId());
        String targetPath = new Path(containerPath).append(name).toString();
        boolean exist = false;
        if (session.exists((DocumentRef)new PathRef(targetPath))) {
            exist = true;
            doc = session.getDocument((DocumentRef)new PathRef(targetPath));
        }
        doc.setPathInfo(containerPath, name);
        doc.setPropertyValue("dc:title", (Serializable)((Object)xi.getId()));
        doc.setPropertyValue("nxcontribution:contribId", (Serializable)((Object)xi.getId()));
        doc.setPropertyValue("nxcontribution:documentation", (Serializable)((Object)xi.getDocumentation()));
        doc.setPropertyValue("nxcontribution:extensionPoint", (Serializable)((Object)xi.getExtensionPoint()));
        doc.setPropertyValue("nxcontribution:targetComponentName", (Serializable)((Object)xi.getTargetComponentName().getName()));
        StringBlob xmlBlob = new StringBlob(xi.getXml());
        xmlBlob.setFilename("contrib.xml");
        xmlBlob.setMimeType("text/xml");
        doc.setPropertyValue("file:content", (Serializable)xmlBlob);
        doc = exist ? session.saveDocument(doc) : session.createDocument(doc);
        return new ExtensionInfoDocAdapter(doc);
    }

    public ExtensionInfoDocAdapter(DocumentModel doc) {
        super(doc);
    }

    @Override
    public String getDocumentation() {
        return this.safeGet("nxcontribution:documentation");
    }

    @Override
    public String getDocumentationHtml() {
        return DocumentationHelper.getHtml(this.getDocumentation());
    }

    @Override
    public String getExtensionPoint() {
        return this.safeGet("nxcontribution:extensionPoint");
    }

    @Override
    public String getId() {
        return this.safeGet("nxcontribution:contribId");
    }

    @Override
    public ComponentName getTargetComponentName() {
        return new ComponentName(this.safeGet("nxcontribution:targetComponentName"));
    }

    @Override
    public String getXml() {
        try {
            Blob xml = this.safeGet(Blob.class, "file:content", null);
            if (xml == null) {
                return "";
            }
            if (xml.getEncoding() == null || "".equals(xml.getEncoding())) {
                xml.setEncoding("utf-8");
            }
            return xml.getString();
        }
        catch (IOException e) {
            log.error((Object)"Error while reading blob", (Throwable)e);
            return "";
        }
    }

    @Override
    public String getVersion() {
        BundleInfo parentBundle = this.getParentNuxeoArtifact(BundleInfo.class);
        if (parentBundle != null) {
            return parentBundle.getVersion();
        }
        log.error((Object)("Unable to determine version for Contribution " + this.getId()));
        return "?";
    }

    @Override
    public String getArtifactType() {
        return "NXContribution";
    }

    @Override
    public String getHierarchyPath() {
        String path = super.getHierarchyPath() + "###";
        String toReplace = "/" + this.getId() + "###";
        return path.replace(toReplace, "/Contributions/" + this.getId());
    }

    @Override
    public List<ContributionItem> getContributionItems() {
        try {
            return XMLContributionParser.extractContributionItems(this.getXml());
        }
        catch (DocumentException e) {
            log.error((Object)e, (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public ComponentInfo getComponent() {
        String cId = this.getId().split("--")[0];
        ComponentInfo parentComponent = this.getParentNuxeoArtifact(ComponentInfo.class);
        if (parentComponent.getId().equals(cId)) {
            return parentComponent;
        }
        return null;
    }
}

