/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.apidoc.adapters;

import java.io.Serializable;
import org.nuxeo.apidoc.adapters.BaseNuxeoArtifactDocAdapter;
import org.nuxeo.apidoc.api.BundleInfo;
import org.nuxeo.apidoc.api.ServiceInfo;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;

public class ServiceInfoDocAdapter
extends BaseNuxeoArtifactDocAdapter
implements ServiceInfo {
    public ServiceInfoDocAdapter(DocumentModel doc) {
        super(doc);
    }

    public static ServiceInfoDocAdapter create(ServiceInfo si, CoreSession session, String containerPath) throws ClientException {
        DocumentModel doc = session.createDocumentModel("NXService");
        String name = ServiceInfoDocAdapter.computeDocumentName("service-" + si.getId());
        String targetPath = new Path(containerPath).append(name).toString();
        boolean exist = false;
        if (session.exists((DocumentRef)new PathRef(targetPath))) {
            exist = true;
            doc = session.getDocument((DocumentRef)new PathRef(targetPath));
        }
        doc.setPathInfo(containerPath, name);
        doc.setPropertyValue("dc:title", (Serializable)((Object)si.getId()));
        doc.setPropertyValue("nxservice:className", (Serializable)((Object)si.getId()));
        doc.setPropertyValue("nxservice:componentId", (Serializable)((Object)si.getComponentId()));
        doc = exist ? session.saveDocument(doc) : session.createDocument(doc);
        return new ServiceInfoDocAdapter(doc);
    }

    @Override
    public String getId() {
        return this.safeGet("nxservice:className", "unknown_service");
    }

    @Override
    public String getArtifactType() {
        return "NXService";
    }

    @Override
    public String getVersion() {
        BundleInfo parentBundle = this.getParentNuxeoArtifact(BundleInfo.class);
        if (parentBundle != null) {
            return parentBundle.getVersion();
        }
        log.error((Object)("Unable to determine version for Service " + this.getId()));
        return "?";
    }

    @Override
    public String getComponentId() {
        return this.safeGet("nxservice:componentId", "unknown_service");
    }

    @Override
    public String getHierarchyPath() {
        String path = super.getHierarchyPath() + "###";
        String toReplace = "/" + this.getId() + "###";
        return path.replace(toReplace, "/Services/" + this.getId());
    }
}

