/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.apidoc.adapters;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.nuxeo.apidoc.adapters.BaseNuxeoArtifactDocAdapter;
import org.nuxeo.apidoc.api.BundleInfo;
import org.nuxeo.apidoc.api.ComponentInfo;
import org.nuxeo.apidoc.api.ExtensionInfo;
import org.nuxeo.apidoc.api.ExtensionPointInfo;
import org.nuxeo.apidoc.api.QueryHelper;
import org.nuxeo.apidoc.api.ServiceInfo;
import org.nuxeo.apidoc.documentation.DocumentationHelper;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;

public class ComponentInfoDocAdapter
extends BaseNuxeoArtifactDocAdapter
implements ComponentInfo {
    public ComponentInfoDocAdapter(DocumentModel doc) {
        super(doc);
    }

    public static ComponentInfoDocAdapter create(ComponentInfo componentInfo, CoreSession session, String containerPath) throws ClientException, IOException {
        DocumentModel doc = session.createDocumentModel("NXComponent");
        String name = ComponentInfoDocAdapter.computeDocumentName("component-" + componentInfo.getId());
        String targetPath = new Path(containerPath).append(name).toString();
        boolean exist = false;
        if (session.exists((DocumentRef)new PathRef(targetPath))) {
            exist = true;
            doc = session.getDocument((DocumentRef)new PathRef(targetPath));
        }
        doc.setPathInfo(containerPath, name);
        doc.setPropertyValue("dc:title", (Serializable)((Object)componentInfo.getName()));
        doc.setPropertyValue("nxcomponent:componentId", (Serializable)((Object)componentInfo.getId()));
        doc.setPropertyValue("nxcomponent:componentName", (Serializable)((Object)componentInfo.getName()));
        doc.setPropertyValue("nxcomponent:componentClass", (Serializable)((Object)componentInfo.getComponentClass()));
        doc.setPropertyValue("nxcomponent:builtInDocumentation", (Serializable)((Object)componentInfo.getDocumentation()));
        doc.setPropertyValue("nxcomponent:isXML", (Serializable)Boolean.valueOf(componentInfo.isXmlPureComponent()));
        doc.setPropertyValue("nxcomponent:services", (Serializable)((Object)componentInfo.getServiceNames()));
        Blob xmlBlob = Blobs.createBlob((String)componentInfo.getXmlFileContent(), (String)"text/xml", null, (String)componentInfo.getXmlFileName());
        doc.setPropertyValue("file:content", (Serializable)xmlBlob);
        doc = exist ? session.saveDocument(doc) : session.createDocument(doc);
        return new ComponentInfoDocAdapter(doc);
    }

    @Override
    public BundleInfo getBundle() {
        try {
            DocumentModel parent = this.getCoreSession().getDocument(this.doc.getParentRef());
            return (BundleInfo)parent.getAdapter(BundleInfo.class);
        }
        catch (ClientException e) {
            log.error((Object)e, (Throwable)e);
            return null;
        }
    }

    @Override
    public String getComponentClass() {
        return this.safeGet("nxcomponent:componentClass");
    }

    @Override
    public String getDocumentation() {
        return this.safeGet("nxcomponent:builtInDocumentation");
    }

    @Override
    public String getDocumentationHtml() {
        return DocumentationHelper.getHtml(this.getDocumentation());
    }

    @Override
    public ExtensionPointInfo getExtensionPoint(String name) {
        return null;
    }

    @Override
    public Collection<ExtensionPointInfo> getExtensionPoints() {
        ArrayList<ExtensionPointInfo> xps = new ArrayList<ExtensionPointInfo>();
        try {
            String query = QueryHelper.select("NXExtensionPoint", this.doc);
            DocumentModelList docs = this.getCoreSession().query(query);
            for (DocumentModel child : docs) {
                ExtensionPointInfo xp = (ExtensionPointInfo)child.getAdapter(ExtensionPointInfo.class);
                if (xp == null) continue;
                xps.add(xp);
            }
        }
        catch (ClientException e) {
            log.error((Object)e, (Throwable)e);
        }
        return xps;
    }

    @Override
    public Collection<ExtensionInfo> getExtensions() {
        ArrayList<ExtensionInfo> contribs = new ArrayList<ExtensionInfo>();
        try {
            String query = QueryHelper.select("NXContribution", this.doc);
            DocumentModelList docs = this.getCoreSession().query(query);
            for (DocumentModel child : docs) {
                ExtensionInfo xp = (ExtensionInfo)child.getAdapter(ExtensionInfo.class);
                if (xp == null) continue;
                contribs.add(xp);
            }
        }
        catch (ClientException e) {
            log.error((Object)e, (Throwable)e);
        }
        return contribs;
    }

    @Override
    public String getName() {
        return this.safeGet("nxcomponent:componentName");
    }

    @Override
    public List<String> getServiceNames() {
        try {
            return (List)((Object)this.doc.getPropertyValue("nxcomponent:services"));
        }
        catch (ClientException e) {
            log.error((Object)"Error while getting service names", (Throwable)e);
            return null;
        }
    }

    @Override
    public String getXmlFileContent() throws IOException {
        try {
            Blob xml = this.safeGet(Blob.class, "file:content", null);
            if (xml.getEncoding() == null || "".equals(xml.getEncoding())) {
                xml.setEncoding("utf-8");
            }
            return xml.getString();
        }
        catch (IOException e) {
            log.error((Object)"Error while reading blob", (Throwable)e);
            return "";
        }
    }

    @Override
    public String getXmlFileName() {
        Blob xml = this.safeGet(Blob.class, "file:content", null);
        return xml == null ? "" : (xml.getFilename() == null ? "" : xml.getFilename());
    }

    @Override
    public URL getXmlFileUrl() {
        return null;
    }

    @Override
    public boolean isXmlPureComponent() {
        Boolean isXml = this.safeGet(Boolean.class, "nxcomponent:isXML", Boolean.TRUE);
        return isXml == null ? true : isXml;
    }

    @Override
    public String getId() {
        return this.getName();
    }

    @Override
    public String getVersion() {
        BundleInfo parentBundle = this.getParentNuxeoArtifact(BundleInfo.class);
        if (parentBundle != null) {
            return parentBundle.getVersion();
        }
        log.error((Object)("Unable to determine version for Component " + this.getId()));
        return "?";
    }

    @Override
    public String getArtifactType() {
        return "NXComponent";
    }

    @Override
    public List<ServiceInfo> getServices() {
        ArrayList<ServiceInfo> result = new ArrayList<ServiceInfo>();
        try {
            String query = QueryHelper.select("NXService", this.doc);
            DocumentModelList docs = this.getCoreSession().query(query);
            for (DocumentModel siDoc : docs) {
                ServiceInfo si = (ServiceInfo)siDoc.getAdapter(ServiceInfo.class);
                if (si == null) continue;
                result.add(si);
            }
        }
        catch (ClientException e) {
            log.error((Object)"Unable to fetch NXService", (Throwable)e);
        }
        return result;
    }
}

