/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.apidoc.adapters;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.apidoc.adapters.BaseNuxeoArtifactDocAdapter;
import org.nuxeo.apidoc.api.OperationInfo;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.automation.OperationDocumentation;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;

public class OperationInfoDocAdapter
extends BaseNuxeoArtifactDocAdapter
implements OperationInfo {
    protected OperationInfoDocAdapter(DocumentModel doc) {
        super(doc);
    }

    @Override
    public String getArtifactType() {
        return "NXOperation";
    }

    @Override
    public String getId() {
        return "op:" + this.getName();
    }

    @Override
    public String getName() {
        return this.safeGet("nxop:name");
    }

    @Override
    public String[] getAliases() {
        try {
            return ((List)((Object)this.doc.getPropertyValue("nxop:aliases"))).toArray(new String[0]);
        }
        catch (ClientException e) {
            log.error((Object)"Unable to get signature field", (Throwable)e);
            return null;
        }
    }

    @Override
    public String getVersion() {
        return this.safeGet("nxop:version");
    }

    @Override
    public String getDescription() {
        return this.safeGet("nxop:description");
    }

    @Override
    public String[] getSignature() {
        try {
            return ((List)((Object)this.doc.getPropertyValue("nxop:signature"))).toArray(new String[0]);
        }
        catch (ClientException e) {
            log.error((Object)"Unable to get signature field", (Throwable)e);
            return null;
        }
    }

    @Override
    public String getCategory() {
        return this.safeGet("nxop:category");
    }

    @Override
    public String getUrl() {
        return this.safeGet("nxop:url");
    }

    @Override
    public String getLabel() {
        return this.safeGet("nxop:label");
    }

    @Override
    public String getRequires() {
        return this.safeGet("nxop:requires");
    }

    @Override
    public String getSince() {
        return this.safeGet("nxop:since");
    }

    @Override
    public List<OperationDocumentation.Param> getParams() {
        List maps;
        try {
            maps = (List)((Object)this.doc.getPropertyValue("nxop:params"));
        }
        catch (ClientException e) {
            throw new RuntimeException(e);
        }
        ArrayList<OperationDocumentation.Param> params = new ArrayList<OperationDocumentation.Param>();
        if (maps != null) {
            for (Map map : maps) {
                OperationDocumentation.Param p = new OperationDocumentation.Param();
                p.name = (String)map.get("name");
                p.type = (String)map.get("type");
                p.widget = (String)map.get("widget");
                p.values = ((List)map.get("values")).toArray(new String[0]);
                Long order = (Long)map.get("order");
                p.order = order == null ? 0 : order.intValue();
                Boolean required = (Boolean)map.get("required");
                p.isRequired = required == null ? false : required;
                params.add(p);
            }
        }
        return params;
    }

    @Override
    public int compareTo(OperationInfo o) {
        String s1 = this.getLabel() == null ? this.getId() : this.getLabel();
        String s2 = o.getLabel() == null ? o.getId() : o.getLabel();
        return s1.compareTo(s2);
    }

    public static OperationInfo create(OperationInfo oi, CoreSession session, String containerPath) throws ClientException {
        DocumentModel doc;
        String name = OperationInfoDocAdapter.computeDocumentName(oi.getId());
        String targetPath = new Path(containerPath).append(name).toString();
        boolean exists = session.exists((DocumentRef)new PathRef(targetPath));
        if (exists) {
            doc = session.getDocument((DocumentRef)new PathRef(targetPath));
        } else {
            doc = session.createDocumentModel("NXOperation");
            doc.setPathInfo(containerPath, name);
        }
        doc.setPropertyValue("dc:title", (Serializable)((Object)oi.getName()));
        doc.setPropertyValue("nxop:name", (Serializable)((Object)oi.getName()));
        doc.setPropertyValue("nxop:aliases", (Serializable)oi.getAliases());
        doc.setPropertyValue("nxop:version", (Serializable)((Object)oi.getVersion()));
        doc.setPropertyValue("nxop:description", (Serializable)((Object)oi.getDescription()));
        doc.setPropertyValue("nxop:signature", (Serializable)oi.getSignature());
        doc.setPropertyValue("nxop:category", (Serializable)((Object)oi.getCategory()));
        doc.setPropertyValue("nxop:url", (Serializable)((Object)oi.getUrl()));
        doc.setPropertyValue("nxop:label", (Serializable)((Object)oi.getLabel()));
        doc.setPropertyValue("nxop:requires", (Serializable)((Object)oi.getRequires()));
        doc.setPropertyValue("nxop:since", (Serializable)((Object)oi.getSince()));
        doc.setPropertyValue("operationClass", (Serializable)((Object)oi.getOperationClass()));
        doc.setPropertyValue("contributingComponent", (Serializable)((Object)oi.getContributingComponent()));
        ArrayList params = new ArrayList();
        for (OperationDocumentation.Param p : oi.getParams()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", p.getName());
            map.put("type", p.getType());
            map.put("widget", p.getWidget());
            map.put("values", p.getValues());
            map.put("required", p.isRequired());
            map.put("order", Long.valueOf(p.getOrder()));
            params.add(map);
        }
        doc.setPropertyValue("nxop:params", (Serializable)params);
        doc = exists ? session.saveDocument(doc) : session.createDocument(doc);
        return new OperationInfoDocAdapter(doc);
    }

    @Override
    public String getOperationClass() {
        return this.safeGet("operationClass");
    }

    @Override
    public String getContributingComponent() {
        return this.safeGet("contributingComponent");
    }
}

