/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.apidoc.introspection;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.apidoc.api.BaseNuxeoArtifact;
import org.nuxeo.apidoc.api.ComponentInfo;
import org.nuxeo.apidoc.api.ExtensionInfo;
import org.nuxeo.apidoc.api.ExtensionPointInfo;
import org.nuxeo.apidoc.api.ServiceInfo;
import org.nuxeo.apidoc.documentation.DocumentationHelper;
import org.nuxeo.apidoc.introspection.BundleInfoImpl;
import org.nuxeo.apidoc.introspection.ExtensionInfoImpl;
import org.nuxeo.apidoc.introspection.ExtensionPointInfoImpl;
import org.nuxeo.apidoc.introspection.ServiceInfoImpl;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.common.utils.Path;

public class ComponentInfoImpl
extends BaseNuxeoArtifact
implements ComponentInfo {
    protected final BundleInfoImpl bundle;
    protected final String name;
    protected final Map<String, ExtensionPointInfo> extensionPoints;
    protected final Collection<ExtensionInfo> extensions;
    protected final List<String> serviceNames = new ArrayList<String>();
    protected final List<ServiceInfo> services = new ArrayList<ServiceInfo>();
    protected URL xmlFileUrl;
    protected String componentClass;
    protected String documentation;
    protected static final Log log = LogFactory.getLog(ComponentInfoImpl.class);

    public ComponentInfoImpl(BundleInfoImpl bundleInfo, String name) {
        this.bundle = bundleInfo;
        this.name = name;
        this.extensionPoints = new HashMap<String, ExtensionPointInfo>();
        this.extensions = new ArrayList<ExtensionInfo>();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public BundleInfoImpl getBundle() {
        return this.bundle;
    }

    @Override
    public Collection<ExtensionPointInfo> getExtensionPoints() {
        return this.extensionPoints.values();
    }

    @Override
    public Collection<ExtensionInfo> getExtensions() {
        return this.extensions;
    }

    public void addExtensionPoint(ExtensionPointInfoImpl xp) {
        this.extensionPoints.put(xp.getId(), xp);
    }

    @Override
    public ExtensionPointInfo getExtensionPoint(String name) {
        return this.extensionPoints.get(name);
    }

    public void addExtension(ExtensionInfoImpl xt) {
        this.extensions.add(xt);
    }

    @Override
    public String getDocumentation() {
        return this.documentation;
    }

    @Override
    public String getDocumentationHtml() {
        return DocumentationHelper.getHtml(this.getDocumentation());
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    public void addService(String serviceName) {
        this.serviceNames.add(serviceName);
        ServiceInfoImpl si = new ServiceInfoImpl(serviceName, this);
        this.services.add(si);
    }

    @Override
    public List<String> getServiceNames() {
        return this.serviceNames;
    }

    @Override
    public String getComponentClass() {
        return this.componentClass;
    }

    public void setComponentClass(String componentClass) {
        this.componentClass = componentClass;
    }

    @Override
    public boolean isXmlPureComponent() {
        return this.componentClass == null;
    }

    @Override
    public URL getXmlFileUrl() {
        return this.xmlFileUrl;
    }

    public void setXmlFileUrl(URL xmlFileUrl) {
        this.xmlFileUrl = xmlFileUrl;
    }

    @Override
    public String getXmlFileName() {
        if (this.xmlFileUrl == null) {
            return "";
        }
        String path = this.xmlFileUrl.getPath();
        String[] parts = path.split("!");
        if (parts.length == 2) {
            return parts[1];
        }
        return path;
    }

    @Override
    public String getXmlFileContent() {
        if (this.xmlFileUrl == null) {
            return "";
        }
        String path = this.xmlFileUrl.getPath();
        String[] parts = path.split("!");
        File jar = new File(parts[0].replace("file:", ""));
        if (!jar.exists()) {
            return "Unable to locate Bundle :" + parts[0];
        }
        try {
            String xml;
            if (jar.getAbsolutePath().endsWith(".xml")) {
                xml = FileUtils.read((InputStream)new FileInputStream(jar));
            } else if (jar.isDirectory()) {
                File file = new File(new Path(jar.getAbsolutePath()).append(parts[1]).toString());
                if (!file.exists()) {
                    return "Unable to locate file :" + file.getAbsolutePath();
                }
                xml = FileUtils.readFile((File)file);
            } else {
                ZipFile jarArchive = new ZipFile(jar);
                ZipEntry entry = jarArchive.getEntry(parts[1].substring(1));
                xml = FileUtils.read((InputStream)jarArchive.getInputStream(entry));
            }
            return DocumentationHelper.secureXML(xml);
        }
        catch (IOException e) {
            log.error((Object)"Error while getting XML file", (Throwable)e);
            return "";
        }
    }

    @Override
    public String getId() {
        return this.name;
    }

    @Override
    public String getVersion() {
        return this.bundle.getVersion();
    }

    @Override
    public String getArtifactType() {
        return "NXComponent";
    }

    @Override
    public List<ServiceInfo> getServices() {
        return this.services;
    }

    @Override
    public String getHierarchyPath() {
        return this.getBundle().getHierarchyPath() + "/" + this.getId();
    }
}

