/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.apidoc.introspection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.apidoc.api.BaseNuxeoArtifact;
import org.nuxeo.apidoc.api.BundleGroup;
import org.nuxeo.apidoc.documentation.AssociatedDocumentsImpl;
import org.nuxeo.apidoc.documentation.ResourceDocumentationItem;
import org.nuxeo.ecm.core.api.CoreSession;

public class BundleGroupImpl
extends BaseNuxeoArtifact
implements BundleGroup {
    protected final String key;
    protected final String name;
    protected final List<BundleGroup> subGroups = new ArrayList<BundleGroup>();
    protected final List<String> bundleIds = new ArrayList<String>();
    protected final String version;
    protected final List<String> parentIds = new ArrayList<String>();
    protected Map<String, ResourceDocumentationItem> liveDoc;

    public BundleGroupImpl(String key, String version) {
        this.key = key;
        this.name = key.startsWith("grp:") ? key.substring(4) : key;
        this.version = version;
    }

    void addParent(String bgId) {
        this.parentIds.add(bgId);
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void add(BundleGroupImpl group) {
        this.subGroups.add(group);
    }

    public void add(String bundleId) {
        this.bundleIds.add(bundleId);
    }

    @Override
    public List<BundleGroup> getSubGroups() {
        return this.subGroups;
    }

    @Override
    public List<String> getBundleIds() {
        return this.bundleIds;
    }

    @Override
    public String getId() {
        return this.key;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getArtifactType() {
        return "NXBundleGroup";
    }

    @Override
    public String getHierarchyPath() {
        String path = "";
        for (String parentId : this.parentIds) {
            path = path + "/" + parentId;
        }
        return path + "/" + this.getId();
    }

    public void addLiveDoc(Map<String, ResourceDocumentationItem> newLiveDoc) {
        if (this.liveDoc == null) {
            this.liveDoc = new HashMap<String, ResourceDocumentationItem>();
        }
        if (newLiveDoc != null) {
            for (String key : newLiveDoc.keySet()) {
                if (newLiveDoc.get(key) == null) continue;
                this.liveDoc.put(key, new ResourceDocumentationItem(newLiveDoc.get(key), this));
            }
        }
    }

    @Override
    public AssociatedDocumentsImpl getAssociatedDocuments(CoreSession session) {
        AssociatedDocumentsImpl docs = super.getAssociatedDocuments(session);
        if (this.liveDoc != null) {
            docs.setLiveDoc(this.liveDoc);
        }
        return docs;
    }

    public Map<String, ResourceDocumentationItem> getLiveDoc() {
        return this.liveDoc;
    }
}

