/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.apidoc.adapters;

import java.io.Serializable;
import java.util.List;
import org.nuxeo.apidoc.adapters.BaseNuxeoArtifactDocAdapter;
import org.nuxeo.apidoc.api.SeamComponentInfo;
import org.nuxeo.apidoc.snapshot.DistributionSnapshot;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.PropertyException;

public class SeamComponentInfoDocAdapter
extends BaseNuxeoArtifactDocAdapter
implements SeamComponentInfo {
    protected SeamComponentInfoDocAdapter(DocumentModel doc) {
        super(doc);
    }

    @Override
    public String getId() {
        return "seam:" + this.getName();
    }

    @Override
    public String getClassName() {
        return this.safeGet("nxseam:className");
    }

    @Override
    public List<String> getInterfaceNames() {
        try {
            return (List)((Object)this.doc.getPropertyValue("nxseam:interfaces"));
        }
        catch (PropertyException e) {
            log.error((Object)"Error while getting service names", (Throwable)e);
            return null;
        }
    }

    @Override
    public String getName() {
        return this.safeGet("nxseam:componentName");
    }

    @Override
    public String getPrecedence() {
        return this.safeGet("nxseam:precedence");
    }

    @Override
    public String getScope() {
        return this.safeGet("nxseam:scope");
    }

    @Override
    public String getArtifactType() {
        return "NXSeamComponent";
    }

    @Override
    public String getVersion() {
        DistributionSnapshot parentSnapshot = this.getParentNuxeoArtifact(DistributionSnapshot.class);
        if (parentSnapshot == null) {
            log.error((Object)("Unable to determine version for bundleGroup " + this.getId()));
            return "?";
        }
        return parentSnapshot.getVersion();
    }

    @Override
    public int compareTo(SeamComponentInfo o) {
        return this.getClassName().compareTo(o.getClassName());
    }

    public static SeamComponentInfo create(SeamComponentInfo sci, CoreSession session, String containerPath) {
        DocumentModel doc = session.createDocumentModel("NXSeamComponent");
        String name = SeamComponentInfoDocAdapter.computeDocumentName(sci.getId());
        String targetPath = new Path(containerPath).append(name).toString();
        boolean exist = false;
        if (session.exists((DocumentRef)new PathRef(targetPath))) {
            exist = true;
            doc = session.getDocument((DocumentRef)new PathRef(targetPath));
        }
        doc.setPathInfo(containerPath, name);
        doc.setPropertyValue("dc:title", (Serializable)((Object)sci.getName()));
        doc.setPropertyValue("nxseam:componentName", (Serializable)((Object)sci.getName()));
        doc.setPropertyValue("nxseam:className", (Serializable)((Object)sci.getClassName()));
        doc.setPropertyValue("nxseam:scope", (Serializable)((Object)sci.getScope()));
        doc.setPropertyValue("nxseam:interfaces", (Serializable)((Object)sci.getInterfaceNames()));
        doc = exist ? session.saveDocument(doc) : session.createDocument(doc);
        return new SeamComponentInfoDocAdapter(doc);
    }
}

