/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.apidoc.adapters;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.nuxeo.apidoc.adapters.BaseNuxeoArtifactDocAdapter;
import org.nuxeo.apidoc.api.BundleInfo;
import org.nuxeo.apidoc.api.ComponentInfo;
import org.nuxeo.apidoc.api.ExtensionInfo;
import org.nuxeo.apidoc.api.ExtensionPointInfo;
import org.nuxeo.apidoc.api.QueryHelper;
import org.nuxeo.apidoc.documentation.DocumentationHelper;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.PropertyException;

public class ExtensionPointInfoDocAdapter
extends BaseNuxeoArtifactDocAdapter
implements ExtensionPointInfo {
    public static ExtensionPointInfoDocAdapter create(ExtensionPointInfo xpi, CoreSession session, String containerPath) {
        DocumentModel doc = session.createDocumentModel("NXExtensionPoint");
        String name = ExtensionPointInfoDocAdapter.computeDocumentName("xp-" + xpi.getId());
        String targetPath = new Path(containerPath).append(name).toString();
        boolean exist = false;
        if (session.exists((DocumentRef)new PathRef(targetPath))) {
            exist = true;
            doc = session.getDocument((DocumentRef)new PathRef(targetPath));
        }
        doc.setPathInfo(containerPath, name);
        doc.setPropertyValue("dc:title", (Serializable)((Object)xpi.getId()));
        doc.setPropertyValue("nxextensionpoint:name", (Serializable)((Object)xpi.getName()));
        doc.setPropertyValue("nxextensionpoint:epId", (Serializable)((Object)xpi.getId()));
        doc.setPropertyValue("nxextensionpoint:documentation", (Serializable)((Object)xpi.getDocumentation()));
        doc.setPropertyValue("nxextensionpoint:extensionPoint", (Serializable)xpi.getDescriptors());
        doc = exist ? session.saveDocument(doc) : session.createDocument(doc);
        return new ExtensionPointInfoDocAdapter(doc);
    }

    public ExtensionPointInfoDocAdapter(DocumentModel doc) {
        super(doc);
    }

    @Override
    public ComponentInfo getComponent() {
        log.error((Object)"getComponent Not implemented");
        return null;
    }

    @Override
    public String getComponentId() {
        return this.getId().split("--")[0];
    }

    @Override
    public String getDocumentation() {
        return this.safeGet("nxextensionpoint:documentation");
    }

    @Override
    public String getDocumentationHtml() {
        return DocumentationHelper.getHtml(this.getDocumentation());
    }

    @Override
    public Collection<ExtensionInfo> getExtensions() {
        ArrayList<ExtensionInfo> result = new ArrayList<ExtensionInfo>();
        DocumentModel dist = this.doc;
        while (!"NXDistribution".equals(dist.getType())) {
            dist = this.getCoreSession().getParentDocument(dist.getRef());
        }
        String query = QueryHelper.select("NXContribution", dist, "nxcontribution:extensionPoint", this.getId());
        DocumentModelList docs = this.getCoreSession().query(query);
        for (DocumentModel contribDoc : docs) {
            ExtensionInfo contrib = (ExtensionInfo)contribDoc.getAdapter(ExtensionInfo.class);
            if (contrib == null) continue;
            result.add(contrib);
        }
        return result;
    }

    @Override
    public String getName() {
        return this.safeGet("nxextensionpoint:name");
    }

    @Override
    public String[] getDescriptors() {
        try {
            List descriptors = (List)((Object)this.doc.getPropertyValue("nxextensionpoint:extensionPoint"));
            return descriptors.toArray(new String[0]);
        }
        catch (PropertyException e) {
            log.error((Object)"Unable to get descriptors field", (Throwable)e);
            return null;
        }
    }

    @Override
    public String getId() {
        return this.safeGet("nxextensionpoint:epId");
    }

    @Override
    public String getVersion() {
        BundleInfo parentBundle = this.getParentNuxeoArtifact(BundleInfo.class);
        if (parentBundle != null) {
            return parentBundle.getVersion();
        }
        log.error((Object)("Unable to determine version for ExtensionPoint " + this.getId()));
        return "?";
    }

    @Override
    public String getArtifactType() {
        return "NXExtensionPoint";
    }

    @Override
    public String getLabel() {
        return this.getName() + " (" + this.getComponent().getId() + ")";
    }

    @Override
    public String getHierarchyPath() {
        String path = super.getHierarchyPath() + "###";
        String toReplace = "/" + this.getId() + "###";
        return path.replace(toReplace, "/ExtensionPoints/" + this.getId());
    }
}

