/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.apidoc.introspection;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BundleIdReader {
    private static final Log log = LogFactory.getLog(BundleIdReader.class);
    protected final Map<String, Long> ids = new HashMap<String, Long>();
    private long count = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void load(File file) {
        FilterInputStream in = null;
        try {
            in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            this.count = ((DataInputStream)in).readLong();
            int size = ((DataInputStream)in).readInt();
            for (int i = 0; i < size; ++i) {
                String key = ((DataInputStream)in).readUTF();
                long id = ((DataInputStream)in).readLong();
                this.ids.put(key, id);
            }
        }
        catch (FileNotFoundException size) {
        }
        catch (IOException e) {
            log.error((Object)"The bundle.ids file is corrupted. Resetting bundle ids.");
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public List<String> getBundleNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.addAll(this.ids.keySet());
        return names;
    }
}

