/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.apidoc.snapshot;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.nuxeo.apidoc.snapshot.DistributionSnapshot;

public class SnapshotResolverHelper {
    protected static final String[] capaliases = new String[]{"cap", "Nuxeo Platform", "Nuxeo cap", "Nuxeo DM", "dm"};

    public static String findBestMatch(List<DistributionSnapshot> snaps, String distributionId) {
        if (distributionId == null || "".equals(distributionId.trim())) {
            return null;
        }
        for (DistributionSnapshot snap : snaps) {
            if (!snap.getKey().equalsIgnoreCase(distributionId)) continue;
            return snap.getKey();
        }
        Optional<DistributionSnapshot> first = snaps.stream().filter(s -> s.getAliases().contains(distributionId)).findFirst();
        if (first.isPresent()) {
            return first.get().getKey();
        }
        String[] parts = distributionId.split("-");
        if (parts.length > 1) {
            String name = parts[0];
            String version = distributionId.replace(name + "-", "");
            name = SnapshotResolverHelper.getName(name);
            ArrayList<String> potentialVersions = new ArrayList<String>();
            HashMap<String, String> dist4Version = new HashMap<String, String>();
            for (DistributionSnapshot snap : snaps) {
                if (!SnapshotResolverHelper.getName(snap.getName()).equalsIgnoreCase(name)) continue;
                potentialVersions.add(snap.getVersion());
                dist4Version.put(snap.getVersion(), snap.getName());
                if (!snap.getVersion().equals(version)) continue;
                return snap.getKey();
            }
            potentialVersions.add(version);
            Collections.sort(potentialVersions);
            int idx = potentialVersions.indexOf(version);
            String targetVersion = null;
            if (idx == potentialVersions.size() - 1) {
                targetVersion = (String)potentialVersions.get(idx - 1);
            } else if (idx < potentialVersions.size() - 1) {
                targetVersion = (String)potentialVersions.get(idx + 1);
            }
            if (targetVersion != null) {
                return (String)dist4Version.get(targetVersion) + "-" + targetVersion;
            }
        }
        return null;
    }

    protected static String getName(String name) {
        Optional<String> first = Arrays.stream(capaliases).filter(s -> name.toLowerCase().startsWith(s.toLowerCase())).findFirst();
        return first.isPresent() ? "cap" : name;
    }
}

