/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.apidoc.adapters;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.nuxeo.apidoc.adapters.BaseNuxeoArtifactDocAdapter;
import org.nuxeo.apidoc.api.BundleInfo;
import org.nuxeo.apidoc.api.ComponentInfo;
import org.nuxeo.apidoc.documentation.ResourceDocumentationItem;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;

public class BundleInfoDocAdapter
extends BaseNuxeoArtifactDocAdapter
implements BundleInfo {
    public static BundleInfoDocAdapter create(BundleInfo bundleInfo, CoreSession session, String containerPath) {
        DocumentModel doc = session.createDocumentModel("NXBundle");
        String name = BundleInfoDocAdapter.computeDocumentName("bundle-" + bundleInfo.getId());
        String targetPath = new Path(containerPath).append(name).toString();
        boolean exist = false;
        if (session.exists((DocumentRef)new PathRef(targetPath))) {
            exist = true;
            doc = session.getDocument((DocumentRef)new PathRef(targetPath));
        }
        doc.setPathInfo(containerPath, name);
        doc.setPropertyValue("dc:title", (Serializable)((Object)bundleInfo.getBundleId()));
        doc.setPropertyValue("nxbundle:artifactGroupId", (Serializable)((Object)bundleInfo.getGroupId()));
        doc.setPropertyValue("nxbundle:artifactId", (Serializable)((Object)bundleInfo.getArtifactId()));
        doc.setPropertyValue("nxbundle:artifactVersion", (Serializable)((Object)bundleInfo.getArtifactVersion()));
        doc.setPropertyValue("nxbundle:bundleId", (Serializable)((Object)bundleInfo.getId()));
        doc.setPropertyValue("nxbundle:jarName", (Serializable)((Object)bundleInfo.getFileName()));
        String manifest = bundleInfo.getManifest();
        if (manifest != null) {
            Blob manifestBlob = Blobs.createBlob((String)manifest);
            manifestBlob.setFilename("MANIFEST.MF");
            doc.setPropertyValue("file:content", (Serializable)manifestBlob);
        }
        doc = exist ? session.saveDocument(doc) : session.createDocument(doc);
        return new BundleInfoDocAdapter(doc);
    }

    public BundleInfoDocAdapter(DocumentModel doc) {
        super(doc);
    }

    @Override
    public String getArtifactId() {
        return this.safeGet("nxbundle:artifactId");
    }

    @Override
    public String getBundleId() {
        return this.safeGet("nxbundle:bundleId");
    }

    @Override
    public Collection<ComponentInfo> getComponents() {
        ArrayList<ComponentInfo> components = new ArrayList<ComponentInfo>();
        DocumentModelList children = this.getCoreSession().getChildren(this.doc.getRef());
        for (DocumentModel child : children) {
            ComponentInfo comp = (ComponentInfo)child.getAdapter(ComponentInfo.class);
            if (comp == null) continue;
            components.add(comp);
        }
        return components;
    }

    @Override
    public String getFileName() {
        return this.safeGet("nxbundle:jarName");
    }

    @Override
    public String getGroupId() {
        return this.safeGet("nxbundle:artifactGroupId");
    }

    @Override
    public String getLocation() {
        return null;
    }

    @Override
    public String getManifest() {
        try {
            Blob mf = this.safeGet(Blob.class, "file:content", null);
            if (mf == null) {
                return "No MANIFEST.MF";
            }
            if (mf.getEncoding() == null || "".equals(mf.getEncoding())) {
                mf.setEncoding("utf-8");
            }
            return mf.getString();
        }
        catch (IOException e) {
            log.error((Object)"Error while reading blob", (Throwable)e);
            return "";
        }
    }

    @Override
    public String[] getRequirements() {
        return null;
    }

    @Override
    public String getArtifactVersion() {
        return this.safeGet("nxbundle:artifactVersion", null);
    }

    @Override
    public String getId() {
        return this.getBundleId();
    }

    @Override
    public String getVersion() {
        return this.getArtifactVersion();
    }

    @Override
    public String getArtifactType() {
        return "NXBundle";
    }

    @Override
    public Map<String, ResourceDocumentationItem> getLiveDoc() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, ResourceDocumentationItem> getParentLiveDoc() {
        throw new UnsupportedOperationException();
    }
}

