/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.apidoc.documentation;

import java.util.LinkedList;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.platform.htmlsanitizer.HtmlSanitizerService;
import org.nuxeo.runtime.api.Framework;

public class DocumentationHelper {
    private static final String BR = "<br/>";
    private static final String BR2 = "<br />";
    private static final String BR3 = "<br>";
    private static final String P = "<p/>";
    private static final String P2 = "<p />";
    private static final String CODE_START = "<code><pre>";
    private static final String CODE_END = "</pre></code>";
    private static final String AUTHOR = "@author";

    private DocumentationHelper() {
    }

    public static String getHtml(String doc) {
        if (doc == null) {
            return "";
        }
        HtmlSanitizerService sanitizer = (HtmlSanitizerService)Framework.getService(HtmlSanitizerService.class);
        if (sanitizer == null && !Framework.isTestModeSet()) {
            throw new RuntimeException("Cannot find HtmlSanitizerService");
        }
        LinkedList<String> lines = new LinkedList<String>();
        lines.add(P);
        boolean newline = true;
        boolean firstcode = false;
        boolean code = false;
        for (String line : doc.split("\n")) {
            if (!code) {
                if ("".equals(line = line.trim()) || BR.equals(line) || BR2.equals(line) || BR3.equals(line) || P.equals(line) || P2.equals(line)) {
                    if (newline) continue;
                    lines.add(P);
                    newline = true;
                    continue;
                }
                if ("<code>".equals(line)) {
                    code = true;
                    firstcode = true;
                    line = CODE_START;
                    if (!newline) {
                        line = P + line;
                    }
                    lines.add(line);
                    newline = false;
                    continue;
                }
                if (line.startsWith(AUTHOR)) {
                    if (!newline) {
                        lines.add(P);
                    }
                    newline = true;
                    continue;
                }
                lines.add(line);
                newline = false;
                continue;
            }
            if ("</code>".equals(line.trim())) {
                code = false;
                line = "</pre></code><p/>";
                newline = true;
            } else {
                line = line.replace("&", "&amp;").replace("<", "&lt;");
            }
            if (firstcode) {
                firstcode = false;
                line = (String)lines.removeLast() + line;
            }
            lines.add(line);
        }
        if (code) {
            lines.add(CODE_END);
        }
        String html = StringUtils.join(lines, (String)"\n");
        if (sanitizer != null) {
            html = sanitizer.sanitizeString(html, null);
        }
        return DocumentationHelper.secureXML(html);
    }

    public static String secureXML(String xml) {
        if (xml == null || !xml.contains("assword")) {
            return xml;
        }
        xml = xml.replaceAll("<([a-zA-Z]*[pP])assword>[^<]*</([a-zA-Z]*)assword>", "<$1assword>********</$2assword>");
        xml = xml.replaceAll("([a-zA-Z]*[pP])assword=\"[^\"]*\"", "$1assword=\"********\"");
        xml = xml.replaceAll("([a-zA-Z]*[pP])assword\">[^<]*<", "$1assword\">********<");
        return xml;
    }
}

