/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.apidoc.documentation;

import com.cforcoding.jmd.MarkDownParserAndSanitizer;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.apidoc.api.AbstractDocumentationItem;
import org.nuxeo.apidoc.api.DocumentationItem;
import org.nuxeo.apidoc.api.NuxeoArtifact;

public class ResourceDocumentationItem
extends AbstractDocumentationItem
implements DocumentationItem {
    protected final String content;
    protected final String filename;
    protected final String target;
    protected final String targetType;
    protected final String type;
    protected final List<String> applicableVersion;

    @JsonCreator
    public ResourceDocumentationItem(@JsonProperty(value="filename") String filename, @JsonProperty(value="content") String content, @JsonProperty(value="type") String type, @JsonProperty(value="target") String target, @JsonProperty(value="targetType") String targetType, @JsonProperty(value="applicableVersion") List<String> applicableVersion, @JsonProperty(value="typeLabel") String typeLabel) {
        super(typeLabel);
        this.content = content;
        this.filename = filename;
        this.type = type;
        this.target = target;
        this.targetType = targetType;
        this.applicableVersion = applicableVersion;
    }

    public ResourceDocumentationItem(String filename, String content, String type, NuxeoArtifact target) {
        this(filename, content, type, target.getId(), target.getArtifactType(), Arrays.asList(target.getVersion()), ResourceDocumentationItem.typeLabelOf(type));
    }

    public ResourceDocumentationItem(ResourceDocumentationItem other, NuxeoArtifact target) {
        this(other.filename, other.content, other.type, target);
    }

    @Override
    @JsonIgnore
    public String getTitle() {
        return this.getCleanName() + " " + this.target;
    }

    protected String getCleanName() {
        if (this.filename == null || this.filename.toLowerCase().startsWith("readme")) {
            return "ReadMe";
        }
        int idx = this.filename.indexOf(".");
        if (idx > 0) {
            return this.filename.substring(0, idx);
        }
        return this.filename;
    }

    @Override
    @JsonIgnore
    public String getContent() {
        MarkDownParserAndSanitizer parser = new MarkDownParserAndSanitizer();
        String xHtml = parser.transform(this.content);
        return xHtml;
    }

    @Override
    @JsonIgnore
    public String getType() {
        return this.type;
    }

    @Override
    @JsonIgnore
    public String getRenderingType() {
        return "html";
    }

    @Override
    public List<String> getApplicableVersion() {
        return this.applicableVersion;
    }

    @Override
    public String getTarget() {
        return this.target;
    }

    @Override
    public String getTargetType() {
        return this.targetType;
    }

    @Override
    @JsonIgnore
    public boolean isApproved() {
        return true;
    }

    @Override
    @JsonIgnore
    public String getId() {
        return this.getTargetType() + "--" + this.filename;
    }

    @Override
    @JsonIgnore
    public String getUUID() {
        return null;
    }

    @Override
    @JsonIgnore
    public Map<String, String> getAttachments() {
        return new HashMap<String, String>();
    }

    @Override
    @JsonIgnore
    public boolean isPlaceHolder() {
        return true;
    }

    @Override
    @JsonIgnore
    public String getEditId() {
        return null;
    }

    @Override
    @JsonIgnore
    public boolean isReadOnly() {
        return true;
    }
}

