/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.apidoc.introspection;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.DocumentException;
import org.nuxeo.apidoc.api.BaseNuxeoArtifact;
import org.nuxeo.apidoc.api.ComponentInfo;
import org.nuxeo.apidoc.api.ExtensionInfo;
import org.nuxeo.apidoc.documentation.ContributionItem;
import org.nuxeo.apidoc.documentation.DocumentationHelper;
import org.nuxeo.apidoc.documentation.XMLContributionParser;
import org.nuxeo.apidoc.introspection.ComponentInfoImpl;
import org.nuxeo.runtime.model.ComponentName;

@JsonIgnoreType
public class ExtensionInfoImpl
extends BaseNuxeoArtifact
implements ExtensionInfo {
    protected static final Log log = LogFactory.getLog(ExtensionInfoImpl.class);
    protected final String id;
    protected final ComponentInfoImpl component;
    protected final String extensionPoint;
    protected String documentation;
    protected String xml;
    protected ComponentName targetComponentName;
    protected Object[] contribution;

    public ExtensionInfoImpl(ComponentInfoImpl component, String xpoint) {
        this.id = component.getId() + "--" + xpoint;
        this.component = component;
        this.extensionPoint = xpoint;
    }

    @Override
    public String getExtensionPoint() {
        return this.targetComponentName.getName() + "--" + this.extensionPoint;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    @Override
    public String getDocumentation() {
        return this.documentation;
    }

    @Override
    public String getDocumentationHtml() {
        return DocumentationHelper.getHtml(this.getDocumentation());
    }

    @Override
    public ComponentName getTargetComponentName() {
        return this.targetComponentName;
    }

    public void setTargetComponentName(ComponentName targetComponentName) {
        this.targetComponentName = targetComponentName;
    }

    @JsonIgnore
    public Object[] getContribution() {
        return this.contribution;
    }

    public void setContribution(Object[] contribution) {
        this.contribution = contribution;
    }

    @Override
    public String getXml() {
        return this.xml;
    }

    public void setXml(String xml) {
        this.xml = xml;
    }

    @Override
    public String getVersion() {
        return this.component.getVersion();
    }

    @Override
    public String getArtifactType() {
        return "NXContribution";
    }

    @Override
    public String getHierarchyPath() {
        return this.component.getHierarchyPath() + "/" + "Contributions" + "/" + this.getId();
    }

    @Override
    public List<ContributionItem> getContributionItems() {
        try {
            return XMLContributionParser.extractContributionItems(this.getXml());
        }
        catch (DocumentException e) {
            log.error((Object)e, (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public ComponentInfo getComponent() {
        return this.component;
    }
}

