/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.apidoc.worker;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.IntStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.work.AbstractWork;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ExtractXmlAttributesWorker
extends AbstractWork {
    private static final long serialVersionUID = 1L;
    public static final String CATEGORY = "apidoc-xml-extractor";

    protected ExtractXmlAttributesWorker(String repositoryName, String docId) {
        super(String.format("%s:%s:xml:extractor", repositoryName, docId));
        this.setDocument(repositoryName, docId);
    }

    public ExtractXmlAttributesWorker(String repositoryName, String originatingUsername, String docId) {
        this(repositoryName, docId);
        this.setOriginatingUsername(originatingUsername);
    }

    public void work() {
        this.setStatus("Extracting");
        this.openSystemSession();
        try {
            DocumentModel doc = this.loadDocument();
            BlobHolder adapter = (BlobHolder)doc.getAdapter(BlobHolder.class);
            String attributes = this.extractAttributes(adapter.getBlob());
            doc.setPropertyValue("adc:attributes", (Serializable)((Object)attributes));
            this.session.saveDocument(doc);
            this.setStatus("Done");
        }
        catch (DocumentNotFoundException doc) {
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            this.setStatus("Failed");
            throw new NuxeoException((Throwable)e);
        }
    }

    protected DocumentModel loadDocument() throws DocumentNotFoundException {
        DocumentRef docRef = this.getDocument().getDocRef();
        DocumentModel doc = this.session.getDocument(docRef);
        doc.putContextData("disableDublinCoreListener", (Serializable)Boolean.valueOf(true));
        return doc;
    }

    public String extractAttributes(Blob blob) throws ParserConfigurationException, SAXException, IOException {
        if (blob == null) {
            return null;
        }
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        HashSet<String> attributes = new HashSet<String>();
        saxParser.parse(blob.getStream(), (DefaultHandler)new Handler(attributes));
        return StringUtils.join(attributes, (char)' ');
    }

    public String getCategory() {
        return CATEGORY;
    }

    public String getTitle() {
        return "XML Attributes extractor for fulltext search";
    }

    protected static class Handler
    extends DefaultHandler {
        private Set<String> attributesSet;

        public Handler(Set<String> attributesSet) {
            this.attributesSet = attributesSet;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, qName, attributes);
            IntStream.range(0, attributes.getLength()).forEach(i -> this.attributesSet.add(attributes.getValue(i)));
        }
    }
}

