/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.apidoc.listener;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.BooleanUtils;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;

public class LatestDistributionsListener
implements EventListener {
    protected static final String DISTRIBUTION_QUERY = "Select * from %s where %s = 1";

    public void handleEvent(Event event) {
        if (!(event.getContext() instanceof DocumentEventContext)) {
            return;
        }
        DocumentEventContext ctx = (DocumentEventContext)event.getContext();
        DocumentModel srcDoc = ctx.getSourceDocument();
        if (!"NXDistribution".equals(srcDoc.getType())) {
            return;
        }
        CoreSession session = ctx.getCoreSession();
        List<String> flags = Arrays.asList("nxdistribution:latestFT", "nxdistribution:latestLTS");
        flags.forEach(flag -> {
            if (BooleanUtils.isFalse((Boolean)((Boolean)srcDoc.getPropertyValue(flag)))) {
                return;
            }
            String query = String.format(DISTRIBUTION_QUERY, "NXDistribution", flag);
            session.query(query).stream().filter(doc -> srcDoc.getId() == null || !doc.getId().equals(srcDoc.getId())).forEach(doc -> {
                doc.setPropertyValue(flag, (Serializable)Boolean.valueOf(false));
                session.saveDocument(doc);
            });
        });
    }
}

