/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.apidoc.introspection;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.List;
import org.nuxeo.apidoc.api.BaseNuxeoArtifact;
import org.nuxeo.apidoc.api.OperationInfo;
import org.nuxeo.ecm.automation.OperationDocumentation;

@JsonIgnoreType
public class OperationInfoImpl
extends BaseNuxeoArtifact
implements OperationInfo {
    protected final String name;
    protected final String version;
    protected final String[] aliases;
    protected final String operationClass;
    protected final String contributingComponent;
    protected final String description;
    protected final String[] signature;
    protected final String category;
    protected final String url;
    protected final String label;
    protected final String requires;
    protected final String since;
    protected final List<OperationDocumentation.Param> params;

    public OperationInfoImpl(@JsonProperty(value="name") String name, @JsonProperty(value="version") String version, @JsonProperty(value="aliases") String[] aliases, @JsonProperty(value="description") String description, @JsonProperty(value="operationClass") String operationClass, @JsonProperty(value="contributingComponent") String contributingComponent, @JsonProperty(value="signature") String[] signature, @JsonProperty(value="category") String category, @JsonProperty(value="url") String url, @JsonProperty(value="label") String label, @JsonProperty(value="requires") String requires, @JsonProperty(value="since") String since, @JsonProperty(value="params") List<OperationDocumentation.Param> params) {
        String[] parts;
        this.name = name;
        this.version = version;
        this.aliases = aliases;
        this.description = description;
        this.operationClass = operationClass;
        this.contributingComponent = contributingComponent == null || contributingComponent.isEmpty() ? "BuiltIn" : ((parts = contributingComponent.split(":")).length > 1 ? parts[1] : contributingComponent);
        this.signature = signature;
        this.category = category;
        this.url = url;
        this.label = label;
        this.requires = requires;
        this.since = since;
        this.params = params;
    }

    public OperationInfoImpl(OperationDocumentation op, String version, String operationClass, String contributingComponent) {
        this(op.getId(), version, op.getAliases(), op.getDescription(), operationClass, contributingComponent, op.getSignature(), op.getCategory(), op.getUrl(), op.getLabel(), op.getRequires(), op.getSince(), Arrays.asList(op.getParams()));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @JsonIgnore
    public String getId() {
        return "op:" + this.name;
    }

    @Override
    public String[] getAliases() {
        return this.aliases;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String[] getSignature() {
        return this.signature;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getRequires() {
        return this.requires;
    }

    @Override
    public String getSince() {
        return this.since;
    }

    @Override
    public List<OperationDocumentation.Param> getParams() {
        return this.params;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    @JsonIgnore
    public String getArtifactType() {
        return "NXOperation";
    }

    @Override
    @JsonIgnore
    public String getHierarchyPath() {
        return "/";
    }

    @Override
    public int compareTo(OperationInfo o) {
        String s1 = this.getLabel() == null ? this.getId() : this.getLabel();
        String s2 = o.getLabel() == null ? o.getId() : o.getLabel();
        return s1.compareTo(s2);
    }

    @Override
    public String getOperationClass() {
        return this.operationClass;
    }

    @Override
    public String getContributingComponent() {
        return this.contributingComponent;
    }
}

