/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.apidoc.adapters;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.nuxeo.apidoc.adapters.BaseNuxeoArtifactDocAdapter;
import org.nuxeo.apidoc.api.BundleGroup;
import org.nuxeo.apidoc.api.BundleInfo;
import org.nuxeo.apidoc.api.QueryHelper;
import org.nuxeo.apidoc.snapshot.DistributionSnapshot;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;

public class BundleGroupDocAdapter
extends BaseNuxeoArtifactDocAdapter
implements BundleGroup {
    public static BundleGroupDocAdapter create(BundleGroup bundleGroup, CoreSession session, String containerPath) {
        DocumentModel doc = session.createDocumentModel("NXBundleGroup");
        String name = BundleGroupDocAdapter.computeDocumentName("bg-" + bundleGroup.getId());
        String targetPath = new Path(containerPath).append(name).toString();
        boolean exist = false;
        if (session.exists((DocumentRef)new PathRef(targetPath))) {
            exist = true;
            doc = session.getDocument((DocumentRef)new PathRef(targetPath));
        }
        doc.setPathInfo(containerPath, name);
        doc.setPropertyValue("dc:title", (Serializable)((Object)bundleGroup.getName()));
        doc.setPropertyValue("nxbundlegroup:groupName", (Serializable)((Object)bundleGroup.getName()));
        doc.setPropertyValue("nxbundlegroup:key", (Serializable)((Object)bundleGroup.getId()));
        doc = exist ? session.saveDocument(doc) : session.createDocument(doc);
        return new BundleGroupDocAdapter(doc);
    }

    public BundleGroupDocAdapter(DocumentModel doc) {
        super(doc);
    }

    @Override
    public List<String> getBundleIds() {
        ArrayList<String> bundles = new ArrayList<String>();
        String query = QueryHelper.select("NXBundle", this.doc);
        DocumentModelList docs = this.getCoreSession().query(query);
        for (DocumentModel child : docs) {
            BundleInfo bi = (BundleInfo)child.getAdapter(BundleInfo.class);
            if (bi == null || bi.getId().equals(this.getId())) continue;
            bundles.add(bi.getId());
        }
        return bundles;
    }

    private String getKey() {
        return this.safeGet("nxbundlegroup:key", "unknown_bundle_group");
    }

    @Override
    public String getName() {
        return this.safeGet("nxbundlegroup:groupName", "unknown_bundle_group");
    }

    @Override
    public List<BundleGroup> getSubGroups() {
        ArrayList<BundleGroup> grps = new ArrayList<BundleGroup>();
        String query = QueryHelper.select("NXBundleGroup", this.doc);
        DocumentModelList docs = this.getCoreSession().query(query);
        for (DocumentModel child : docs) {
            BundleGroup grp = (BundleGroup)child.getAdapter(BundleGroup.class);
            if (grp == null) continue;
            grps.add(grp);
        }
        return grps;
    }

    @Override
    public String getId() {
        return this.getKey();
    }

    @Override
    public String getVersion() {
        DistributionSnapshot parentSnapshot = this.getParentNuxeoArtifact(DistributionSnapshot.class);
        if (parentSnapshot == null) {
            log.error((Object)("Unable to determine version for bundleGroup " + this.getId()));
            return "?";
        }
        return parentSnapshot.getVersion();
    }

    @Override
    public String getArtifactType() {
        return "NXBundleGroup";
    }

    @Override
    public List<String> getParentIds() {
        throw new UnsupportedOperationException();
    }
}

