/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.apidoc.introspection;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import org.nuxeo.apidoc.introspection.DateTimeFormat;

public class XMLWriter {
    protected static final String CRLF = System.getProperty("line.separator");
    protected int indent;
    protected Writer writer;
    protected String crlf;
    protected boolean emitHeader = true;
    protected String encoding;
    protected ArrayList<String> globalNsMap;
    protected Element element;
    protected int depth = -1;
    public static final String LESS_THAN_ENTITY = "&lt;";
    public static final String GREATER_THAN_ENTITY = "&gt;";
    public static final String AMPERSAND_ENTITY = "&amp;";
    public static final String APOSTROPHE_ENTITY = "&apos;";
    public static final String QUOTE_ENTITY = "&quot;";

    public XMLWriter(Writer writer) {
        this(writer, 0);
    }

    public XMLWriter(Writer writer, int indent) {
        this(writer, indent, CRLF);
    }

    public XMLWriter(Writer writer, int indent, String crlf) {
        this.writer = writer;
        this.indent = indent;
        this.crlf = crlf;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void putXmlns(String uri) {
        this.putXmlns("", uri);
    }

    public void putXmlns(String prefix, String uri) {
        if (this.globalNsMap == null) {
            this.globalNsMap = new ArrayList();
        }
        this.globalNsMap.add(uri);
        this.globalNsMap.add(prefix);
    }

    public String getXmlNs(String uri) {
        if (this.globalNsMap != null) {
            int len = this.globalNsMap.size();
            for (int i = 0; i < len; i += 2) {
                if (!uri.equals(this.globalNsMap.get(i))) continue;
                return this.globalNsMap.get(i + 1);
            }
        }
        return null;
    }

    public void setIndent(int indent) {
        this.indent = indent;
    }

    public int getIndent() {
        return this.indent;
    }

    public void setCRLF(String crlf) {
        this.crlf = crlf;
    }

    public String getCRLF() {
        return this.crlf;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public void setEmitHeader(boolean emitHeader) {
        this.emitHeader = emitHeader;
    }

    public boolean isEmitHeader() {
        return this.emitHeader;
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public void close() throws IOException {
        this.writer.close();
    }

    protected void done() throws IOException {
        this.writer.flush();
    }

    public XMLWriter write(String text) throws IOException {
        this.writer.write(text);
        return this;
    }

    public void indent(String text) throws IOException {
        if (this.indent > 0) {
            this.writer.write(this.crlf);
            char[] buf = new char[this.depth * this.indent];
            Arrays.fill(buf, ' ');
            this.writer.write(buf);
        }
        this.writer.write(text);
    }

    public XMLWriter element(String name) throws IOException {
        if (this.element != null && !this.element.isContainer) {
            this.pop();
            this.writer.write("/>");
        }
        this.indent("<");
        this.writer.write(name);
        if (this.element == null && this.globalNsMap != null) {
            int len = this.globalNsMap.size();
            for (int i = 0; i < len; i += 2) {
                String prefix = this.globalNsMap.get(i + 1);
                String uri = this.globalNsMap.get(i);
                this.writer.write(" xmlns");
                if (prefix != null && prefix.length() > 0) {
                    this.writer.write(":");
                    this.writer.write(prefix);
                }
                this.writer.write("=\"");
                this.writer.write(uri);
                this.writer.write("\"");
            }
        }
        this.push(name);
        return this;
    }

    public XMLWriter start() throws IOException {
        ++this.depth;
        if (this.element == null) {
            if (this.emitHeader) {
                if (this.encoding != null) {
                    this.writer.write("<?xml version=\"1.0\" encoding=" + this.encoding + "?>");
                } else {
                    this.writer.write("<?xml version=\"1.0\"?>");
                }
                this.writer.write(this.crlf);
            }
        } else {
            this.element.isContainer = true;
            this.writer.write(">");
        }
        return this;
    }

    public XMLWriter end() throws IOException {
        --this.depth;
        if (this.element == null) {
            this.done();
        } else {
            if (!this.element.isContainer) {
                this.pop();
                this.writer.write("/>");
            }
            Element myself = this.pop();
            this.indent("</");
            this.writer.write(myself.name);
            this.writer.write(">");
        }
        return this;
    }

    public XMLWriter content(String text) throws IOException {
        this.start();
        --this.depth;
        this.writer.write(text);
        Element elem = this.pop();
        this.writer.write("</");
        this.writer.write(elem.name);
        this.writer.write(">");
        return this;
    }

    public XMLWriter econtent(String text) throws IOException {
        return this.content(XMLWriter.escapeBodyValue(text));
    }

    public XMLWriter content(boolean value) throws IOException {
        return this.content(value ? "true" : "false");
    }

    public XMLWriter content(Date value) throws IOException {
        return this.content(DateTimeFormat.abderaFormat(value));
    }

    public XMLWriter text(String text) throws IOException {
        this.indent(text);
        return this;
    }

    public XMLWriter etext(String text) throws IOException {
        return this.text(XMLWriter.escapeBodyValue(text));
    }

    public XMLWriter attr(String name, Object value) throws IOException {
        this.writer.write(" ");
        this.writer.write(name);
        this.writer.write("=\"");
        this.writer.write(value.toString());
        this.writer.write("\"");
        return this;
    }

    public XMLWriter eattr(String name, Object value) throws IOException {
        return this.attr(name, (Object)XMLWriter.escapeAttributeValue(value));
    }

    public XMLWriter xmlns(String value) throws IOException {
        this.attr("xmlns", (Object)value);
        this.element.putXmlns("", value);
        return this;
    }

    public XMLWriter xmlns(String name, String value) throws IOException {
        this.attr("xmlns:" + name, (Object)value);
        this.element.putXmlns(name, value);
        return this;
    }

    public XMLWriter attr(String name) throws IOException {
        this.writer.write(" ");
        this.writer.write(name);
        this.writer.write("=\"");
        return this;
    }

    public XMLWriter string(String value) throws IOException {
        this.writer.write(value);
        this.writer.write("\"");
        return this;
    }

    public XMLWriter object(Object value) throws IOException {
        this.writer.write(value.toString());
        this.writer.write("\"");
        return this;
    }

    public XMLWriter date(Date value) throws IOException {
        this.writer.write(XMLWriter.format(value));
        this.writer.write("\"");
        return this;
    }

    public XMLWriter integer(long value) throws IOException {
        this.writer.write(Long.toString(value));
        this.writer.write("\"");
        return this;
    }

    public XMLWriter number(double value) throws IOException {
        this.writer.write(Double.toString(value));
        this.writer.write("\"");
        return this;
    }

    public XMLWriter bool(String name, boolean value) throws IOException {
        this.attr(name, (Object)(value ? "true" : "false"));
        return this;
    }

    public XMLWriter integer(String name, long value) throws IOException {
        return this.attr(name, (Object)Long.toString(value));
    }

    public XMLWriter number(String name, double value) throws IOException {
        return this.attr(name, (Object)Double.toString(value));
    }

    public XMLWriter date(String name, Date value) throws IOException {
        return this.attr(name, (Object)value.toString());
    }

    public String resolve(QName name) {
        String prefix = null;
        String uri = name.getNamespaceURI();
        if (this.element != null) {
            prefix = this.element.getXmlNs(uri);
            if (prefix == null) {
                prefix = this.getXmlNs(uri);
            }
        } else {
            prefix = this.getXmlNs(uri);
        }
        if (prefix == null) {
            return name.toString();
        }
        if (prefix.length() == 0) {
            return name.getLocalPart();
        }
        return prefix + ":" + name.getLocalPart();
    }

    public XMLWriter element(QName name) throws IOException {
        return this.element(this.resolve(name));
    }

    public XMLWriter attr(QName name, Object value) throws IOException {
        return this.attr(this.resolve(name), value);
    }

    public XMLWriter eattr(QName name, Object value) throws IOException {
        return this.eattr(this.resolve(name), value);
    }

    public XMLWriter attr(QName name) throws IOException {
        return this.attr(this.resolve(name));
    }

    public XMLWriter bool(QName name, boolean value) throws IOException {
        return this.bool(this.resolve(name), value);
    }

    public XMLWriter integer(QName name, long value) throws IOException {
        return this.integer(this.resolve(name), value);
    }

    public XMLWriter number(QName name, double value) throws IOException {
        return this.number(this.resolve(name), value);
    }

    public XMLWriter date(QName name, Date value) throws IOException {
        return this.date(this.resolve(name), value);
    }

    public static String format(Date date) {
        StringBuilder sb = new StringBuilder();
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        c.setTime(date);
        sb.append(c.get(1));
        sb.append('-');
        int f = c.get(2);
        if (f < 9) {
            sb.append('0');
        }
        sb.append(f + 1);
        sb.append('-');
        f = c.get(5);
        if (f < 10) {
            sb.append('0');
        }
        sb.append(f);
        sb.append('T');
        f = c.get(11);
        if (f < 10) {
            sb.append('0');
        }
        sb.append(f);
        sb.append(':');
        f = c.get(12);
        if (f < 10) {
            sb.append('0');
        }
        sb.append(f);
        sb.append(':');
        f = c.get(13);
        if (f < 10) {
            sb.append('0');
        }
        sb.append(f);
        sb.append('.');
        f = c.get(14);
        if (f < 100) {
            sb.append('0');
        }
        if (f < 10) {
            sb.append('0');
        }
        sb.append(f);
        sb.append('Z');
        return sb.toString();
    }

    public static final String escapeBodyValue(Object value) {
        StringBuffer buffer = new StringBuffer(value.toString());
        int size = buffer.length();
        block5: for (int i = 0; i < size; ++i) {
            switch (buffer.charAt(i)) {
                case '<': {
                    buffer.replace(i, i + 1, LESS_THAN_ENTITY);
                    size += 3;
                    i += 3;
                    continue block5;
                }
                case '>': {
                    buffer.replace(i, i + 1, GREATER_THAN_ENTITY);
                    size += 3;
                    i += 3;
                    continue block5;
                }
                case '&': {
                    buffer.replace(i, i + 1, AMPERSAND_ENTITY);
                    size += 4;
                    i += 4;
                }
            }
        }
        return buffer.toString();
    }

    public static final String escapeAttributeValue(Object value) {
        StringBuffer buffer = new StringBuffer(value.toString());
        int size = buffer.length();
        block7: for (int i = 0; i < size; ++i) {
            switch (buffer.charAt(i)) {
                case '<': {
                    buffer.replace(i, i + 1, LESS_THAN_ENTITY);
                    size += 3;
                    i += 3;
                    continue block7;
                }
                case '>': {
                    buffer.replace(i, i + 1, GREATER_THAN_ENTITY);
                    size += 3;
                    i += 3;
                    continue block7;
                }
                case '&': {
                    buffer.replace(i, i + 1, AMPERSAND_ENTITY);
                    size += 4;
                    i += 4;
                    continue block7;
                }
                case '\'': {
                    buffer.replace(i, i + 1, APOSTROPHE_ENTITY);
                    size += 5;
                    i += 5;
                    continue block7;
                }
                case '\"': {
                    buffer.replace(i, i + 1, QUOTE_ENTITY);
                    size += 5;
                    i += 5;
                }
            }
        }
        return buffer.toString();
    }

    Element push(String name) {
        this.element = new Element(name);
        return this.element;
    }

    Element pop() {
        Element el = this.element;
        if (el != null) {
            this.element = el.parent;
        }
        return el;
    }

    class Element {
        final String name;
        final Element parent;
        ArrayList<String> nsMap;
        boolean isContainer;

        Element(String name) {
            this.name = name;
            this.parent = XMLWriter.this.element;
        }

        void putXmlns(String prefix, String uri) {
            if (this.nsMap == null) {
                this.nsMap = new ArrayList();
            }
            this.nsMap.add(uri);
            this.nsMap.add(prefix);
        }

        String getXmlNs(String uri) {
            if (this.nsMap != null) {
                int len = this.nsMap.size();
                for (int i = 0; i < len; i += 2) {
                    if (!uri.equals(this.nsMap.get(i))) continue;
                    return this.nsMap.get(i + 1);
                }
            }
            if (this.parent != null) {
                return this.parent.getXmlNs(uri);
            }
            return null;
        }
    }
}

