/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.apidoc.snapshot;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.apidoc.api.SeamComponentInfo;
import org.nuxeo.apidoc.introspection.OperationInfoImpl;

public class SnapshotFilter {
    protected final String bundleGroupName;
    protected final List<String> bundlePrefixes = new ArrayList<String>();
    protected final List<String> packagesPrefixes = new ArrayList<String>();

    public SnapshotFilter(String groupName) {
        this.bundleGroupName = groupName;
    }

    public String getBundleGroupName() {
        return this.bundleGroupName;
    }

    public List<String> getBundlePrefixes() {
        return this.bundlePrefixes;
    }

    public void addBundlePrefix(String bundlePrefix) {
        this.bundlePrefixes.add(bundlePrefix);
    }

    public List<String> getPackagesPrefixes() {
        return this.packagesPrefixes;
    }

    public void addPackagesPrefix(String packagesPrefix) {
        this.packagesPrefixes.add(packagesPrefix);
    }

    public boolean includeBundleId(String bundleId) {
        for (String bprefix : this.bundlePrefixes) {
            if (!bundleId.startsWith(bprefix)) continue;
            return true;
        }
        return false;
    }

    public boolean includeSeamComponent(SeamComponentInfo seamComponent) {
        for (String iface : seamComponent.getInterfaceNames()) {
            for (String pprefix : this.packagesPrefixes) {
                if (!iface.startsWith(pprefix)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean includeOperation(OperationInfoImpl op) {
        for (String pprefix : this.packagesPrefixes) {
            if (!op.getOperationClass().startsWith(pprefix)) continue;
            return true;
        }
        return false;
    }
}

