/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.apidoc.browse;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Date;
import java.text.ParseException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.apidoc.browse.SecurityHelper;
import org.nuxeo.apidoc.documentation.DocumentationService;
import org.nuxeo.apidoc.export.ArchiveFile;
import org.nuxeo.apidoc.listener.AttributesExtractorStater;
import org.nuxeo.apidoc.snapshot.DistributionSnapshot;
import org.nuxeo.apidoc.snapshot.DistributionSnapshotDesc;
import org.nuxeo.apidoc.snapshot.SnapshotFilter;
import org.nuxeo.apidoc.snapshot.SnapshotManager;
import org.nuxeo.apidoc.snapshot.SnapshotResolverHelper;
import org.nuxeo.apidoc.worker.ExtractXmlAttributesWorker;
import org.nuxeo.common.Environment;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.query.QueryFilter;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.webengine.forms.FormData;
import org.nuxeo.ecm.webengine.model.Resource;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;
import org.nuxeo.ecm.webengine.model.impl.ModuleRoot;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

@Path(value="/distribution")
@WebObject(type="distribution")
public class Distribution
extends ModuleRoot {
    public static final String DIST_ID = "distId";
    protected static final Log log = LogFactory.getLog(Distribution.class);
    protected static final Pattern VERSION_REGEX = Pattern.compile("^(\\d+)(?:\\.(\\d+))?(?:\\.(\\d+))?(?:-.*)?$", 2);

    public Object handleError(Throwable t) {
        if (t instanceof WebResourceNotFoundException) {
            return Response.status((int)404).entity((Object)this.getTemplate("error/error_404.ftl")).type("text/html").build();
        }
        return super.handleError(t);
    }

    protected SnapshotManager getSnapshotManager() {
        return (SnapshotManager)Framework.getLocalService(SnapshotManager.class);
    }

    public String getNavigationPoint() {
        String currentUrl = this.getContext().getURL();
        String navPoint = "somewhere";
        if (currentUrl.contains("/listBundles")) {
            navPoint = "listBundles";
        } else if (currentUrl.contains("/listSeamComponents")) {
            navPoint = "listSeamComponents";
        } else if (currentUrl.contains("/viewSeamComponent")) {
            navPoint = "viewSeamComponent";
        } else if (currentUrl.contains("/listComponents")) {
            navPoint = "listComponents";
        } else if (currentUrl.contains("/listServices")) {
            navPoint = "listServices";
        } else if (currentUrl.contains("/listExtensionPoints")) {
            navPoint = "listExtensionPoints";
        } else if (currentUrl.contains("/listContributions")) {
            navPoint = "listContributions";
        } else if (currentUrl.contains("/listBundleGroups")) {
            navPoint = "listBundleGroups";
        } else if (currentUrl.contains("/viewBundleGroup")) {
            navPoint = "viewBundleGroup";
        } else if (currentUrl.contains("/viewComponent")) {
            navPoint = "viewComponent";
        } else if (currentUrl.contains("/viewService")) {
            navPoint = "viewService";
        } else if (currentUrl.contains("/viewExtensionPoint")) {
            navPoint = "viewExtensionPoint";
        } else if (currentUrl.contains("/viewContribution")) {
            navPoint = "viewContribution";
        } else if (currentUrl.contains("/viewBundle")) {
            navPoint = "viewBundle";
        } else if (currentUrl.contains("/listOperations")) {
            navPoint = "listOperations";
        } else if (currentUrl.contains("/viewOperation")) {
            navPoint = "viewOperation";
        } else if (currentUrl.contains("/doc")) {
            navPoint = "documentation";
        }
        return navPoint;
    }

    @GET
    @Produces(value={"text/html"})
    public Object doGet() {
        return this.getView("index").arg("hideNav", (Object)Boolean.TRUE);
    }

    @Path(value="latest")
    public Resource getLatest() {
        List<DistributionSnapshot> snaps = this.listPersistedDistributions();
        Optional<DistributionSnapshot> distribution = snaps.stream().filter(snap -> snap.getName().toLowerCase().startsWith("nuxeo platform")).findFirst();
        String latest = "current";
        if (distribution.isPresent()) {
            latest = distribution.get().getKey();
        }
        return this.ctx.newObject("redirectWO", new Object[]{"latest", latest});
    }

    @Path(value="{distributionId}")
    public Resource viewDistribution(@PathParam(value="distributionId") String distributionId) {
        if (distributionId == null || "".equals(distributionId)) {
            return this;
        }
        List snaps = this.getSnapshotManager().listPersistentSnapshots(this.ctx.getCoreSession());
        if (distributionId.matches(VERSION_REGEX.toString())) {
            String finalDistributionId = distributionId;
            String distribution = snaps.stream().filter(s -> s.getVersion().equals(finalDistributionId)).findFirst().map(DistributionSnapshot::getKey).orElse("current");
            return this.ctx.newObject("redirectWO", new Object[]{finalDistributionId, distribution});
        }
        String orgDistributionId = distributionId;
        Boolean embeddedMode = Boolean.FALSE;
        if ("adm".equals(distributionId)) {
            embeddedMode = Boolean.TRUE;
        } else {
            snaps.add(this.getSnapshotManager().getRuntimeSnapshot());
            distributionId = SnapshotResolverHelper.findBestMatch((List)snaps, (String)distributionId);
        }
        if (distributionId == null || "".equals(distributionId)) {
            distributionId = "current";
        }
        if (!orgDistributionId.equals(distributionId)) {
            return this.ctx.newObject("redirectWO", new Object[]{orgDistributionId, distributionId});
        }
        this.ctx.setProperty("embeddedMode", (Object)embeddedMode);
        this.ctx.setProperty("distribution", (Object)this.getSnapshotManager().getSnapshot(distributionId, this.ctx.getCoreSession()));
        this.ctx.setProperty(DIST_ID, (Object)distributionId);
        return this.ctx.newObject("apibrowser", new Object[]{distributionId, embeddedMode});
    }

    public List<DistributionSnapshotDesc> getAvailableDistributions() {
        return this.getSnapshotManager().getAvailableDistributions(this.ctx.getCoreSession());
    }

    public String getRuntimeDistributionName() {
        return "current";
    }

    public DistributionSnapshot getRuntimeDistribution() {
        return this.getSnapshotManager().getRuntimeSnapshot();
    }

    public List<DistributionSnapshot> listPersistedDistributions() {
        SnapshotManager sm = this.getSnapshotManager();
        return sm.listPersistentSnapshots(this.ctx.getCoreSession()).stream().sorted((o1, o2) -> {
            Matcher m1 = VERSION_REGEX.matcher(o1.getVersion());
            Matcher m2 = VERSION_REGEX.matcher(o2.getVersion());
            if (m1.matches() && m2.matches()) {
                for (int i = 0; i < 3; ++i) {
                    int c2;
                    String s1 = m1.group(i + 1);
                    int c1 = s1 != null ? Integer.parseInt(s1) : 0;
                    String s2 = m2.group(i + 1);
                    int n = c2 = s2 != null ? Integer.parseInt(s2) : 0;
                    if (c1 == c2 && i != 2) continue;
                    return Integer.compare(c2, c1);
                }
            }
            log.info((Object)String.format("Comparing version using String between %s - %s", o1.getVersion(), o2.getVersion()));
            return o2.getVersion().compareTo(o1.getVersion());
        }).filter(s -> !s.isHidden()).collect(Collectors.toList());
    }

    public Map<String, DistributionSnapshot> getPersistedDistributions() {
        return this.getSnapshotManager().getPersistentSnapshots(this.ctx.getCoreSession());
    }

    public DistributionSnapshot getCurrentDistribution() {
        String distId = (String)this.ctx.getProperty(DIST_ID);
        DistributionSnapshot currentDistribution = (DistributionSnapshot)this.ctx.getProperty("currentDistribution");
        if (currentDistribution == null || !currentDistribution.getKey().equals(distId)) {
            currentDistribution = this.getSnapshotManager().getSnapshot(distId, this.ctx.getCoreSession());
            this.ctx.setProperty("currentDistribution", (Object)currentDistribution);
        }
        return currentDistribution;
    }

    @POST
    @Path(value="save")
    @Produces(value={"text/html"})
    public Object doSave() throws NamingException, NotSupportedException, SystemException, RollbackException, HeuristicMixedException, HeuristicRollbackException, ParseException {
        if (!this.canAddDocumentation()) {
            return null;
        }
        FormData formData = this.getContext().getForm();
        String distribLabel = formData.getString("name");
        log.info((Object)"Start Snapshot...");
        boolean startedTx = false;
        UserTransaction tx = TransactionHelper.lookupUserTransaction();
        if (tx != null && !TransactionHelper.isTransactionActiveOrMarkedRollback()) {
            tx.begin();
            startedTx = true;
        }
        Map<String, Serializable> otherProperties = this.readFormData(formData);
        try {
            this.getSnapshotManager().persistRuntimeSnapshot(this.getContext().getCoreSession(), distribLabel, otherProperties);
        }
        catch (NuxeoException e) {
            log.error((Object)"Error during storage", (Throwable)e);
            if (tx != null) {
                tx.rollback();
            }
            return this.getView("savedKO").arg("message", (Object)e.getMessage());
        }
        log.info((Object)"Snapshot saved.");
        if (tx != null && startedTx) {
            tx.commit();
        }
        String redirectUrl = this.getContext().getBaseURL() + this.getPath();
        log.debug((Object)("Path => " + redirectUrl));
        return this.getView("saved");
    }

    protected Map<String, Serializable> readFormData(FormData formData) {
        HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
        String released = formData.getString("released");
        if (StringUtils.isNotBlank((CharSequence)released)) {
            LocalDate date = LocalDate.parse(released);
            Instant instant = date.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant();
            properties.put("nxdistribution:released", Date.from(instant));
        }
        return properties;
    }

    @POST
    @Path(value="saveExtended")
    @Produces(value={"text/html"})
    public Object doSaveExtended() throws NamingException, NotSupportedException, SystemException, SecurityException, RollbackException, HeuristicMixedException, HeuristicRollbackException {
        if (!this.canAddDocumentation()) {
            return null;
        }
        FormData formData = this.getContext().getForm();
        String distribLabel = formData.getString("name");
        String bundleList = formData.getString("bundles");
        String pkgList = formData.getString("packages");
        SnapshotFilter filter = new SnapshotFilter(distribLabel);
        if (bundleList != null) {
            String[] bundles;
            for (String bundleId : bundles = bundleList.split("\n")) {
                filter.addBundlePrefix(bundleId);
            }
        }
        if (pkgList != null) {
            String[] packages;
            for (String pkg : packages = pkgList.split("\\r?\\n")) {
                filter.addPackagesPrefix(pkg);
            }
        }
        Map<String, Serializable> otherProperties = this.readFormData(formData);
        log.info((Object)"Start Snapshot...");
        boolean startedTx = false;
        UserTransaction tx = TransactionHelper.lookupUserTransaction();
        if (tx != null && !TransactionHelper.isTransactionActiveOrMarkedRollback()) {
            tx.begin();
            startedTx = true;
        }
        try {
            this.getSnapshotManager().persistRuntimeSnapshot(this.getContext().getCoreSession(), distribLabel, otherProperties, filter);
        }
        catch (NuxeoException e) {
            log.error((Object)"Error during storage", (Throwable)e);
            if (tx != null) {
                tx.rollback();
            }
            return this.getView("savedKO").arg("message", (Object)e.getMessage());
        }
        log.info((Object)"Snapshot saved.");
        if (tx != null && startedTx) {
            tx.commit();
        }
        return this.getView("saved");
    }

    public String getDocumentationInfo() {
        DocumentationService ds = (DocumentationService)Framework.getService(DocumentationService.class);
        return ds.getDocumentationStats(this.getContext().getCoreSession());
    }

    protected File getExportTmpFile() {
        File tmpFile = new File(Environment.getDefault().getTemp(), "export.zip");
        if (tmpFile.exists()) {
            tmpFile.delete();
        }
        tmpFile.deleteOnExit();
        return tmpFile;
    }

    @GET
    @Path(value="downloadDoc")
    public Response downloadDoc() throws IOException {
        DocumentationService ds = (DocumentationService)Framework.getService(DocumentationService.class);
        File tmp = this.getExportTmpFile();
        tmp.createNewFile();
        FileOutputStream out = new FileOutputStream(tmp);
        ds.exportDocumentation(this.getContext().getCoreSession(), (OutputStream)out);
        out.flush();
        ((OutputStream)out).close();
        ArchiveFile aFile = new ArchiveFile(tmp.getAbsolutePath());
        return Response.ok((Object)aFile).header("Content-Disposition", (Object)"attachment;filename=nuxeo-documentation.zip").type("application/zip").build();
    }

    @GET
    @Path(value="download/{distributionId}")
    public Response downloadDistrib(@PathParam(value="distributionId") String distribId) throws IOException {
        File tmp = this.getExportTmpFile();
        tmp.createNewFile();
        FileOutputStream out = new FileOutputStream(tmp);
        this.getSnapshotManager().exportSnapshot(this.getContext().getCoreSession(), distribId, (OutputStream)out);
        ((OutputStream)out).close();
        String fName = "nuxeo-distribution-" + distribId + ".zip";
        fName = fName.replace(" ", "_");
        ArchiveFile aFile = new ArchiveFile(tmp.getAbsolutePath());
        return Response.ok((Object)aFile).header("Content-Disposition", (Object)("attachment;filename=" + fName)).type("application/zip").build();
    }

    @GET
    @Path(value="_admin")
    public Object getForms() {
        NuxeoPrincipal principal = (NuxeoPrincipal)this.getContext().getPrincipal();
        if (SecurityHelper.canEditDocumentation(principal)) {
            return this.getView("forms").arg("hideNav", (Object)Boolean.TRUE);
        }
        return Response.status((int)401).build();
    }

    @POST
    @Path(value="uploadDistrib")
    @Produces(value={"text/html"})
    public Object uploadDistrib() throws IOException {
        if (!this.canAddDocumentation()) {
            return null;
        }
        Blob blob = this.getContext().getForm().getFirstBlob();
        this.getSnapshotManager().importSnapshot(this.getContext().getCoreSession(), blob.getStream());
        this.getSnapshotManager().readPersistentSnapshots(this.getContext().getCoreSession());
        return this.getView("index");
    }

    @POST
    @Path(value="uploadDistribTmp")
    @Produces(value={"text/html"})
    public Object uploadDistribTmp() throws IOException {
        if (!this.canAddDocumentation()) {
            return null;
        }
        Blob blob = this.getContext().getForm().getFirstBlob();
        if (blob == null || blob.getLength() == 0L) {
            return null;
        }
        DocumentModel snap = this.getSnapshotManager().importTmpSnapshot(this.getContext().getCoreSession(), blob.getStream());
        if (snap == null) {
            log.error((Object)"Unable to import archive");
            return null;
        }
        DistributionSnapshot snapObject = (DistributionSnapshot)snap.getAdapter(DistributionSnapshot.class);
        return this.getView("uploadEdit").arg("tmpSnap", (Object)snap).arg("snapObject", (Object)snapObject);
    }

    @POST
    @Path(value="uploadDistribTmpValid")
    @Produces(value={"text/html"})
    public Object uploadDistribTmpValid() {
        if (!this.canAddDocumentation()) {
            return null;
        }
        FormData formData = this.getContext().getForm();
        String name = formData.getString("name");
        String version = formData.getString("version");
        String pathSegment = formData.getString("pathSegment");
        String title = formData.getString("title");
        this.getSnapshotManager().validateImportedSnapshot(this.getContext().getCoreSession(), name, version, pathSegment, title);
        this.getSnapshotManager().readPersistentSnapshots(this.getContext().getCoreSession());
        return this.getView("importDone");
    }

    @POST
    @Path(value="uploadDoc")
    @Produces(value={"text/html"})
    public Object uploadDoc() throws IOException {
        if (!this.canAddDocumentation()) {
            return null;
        }
        Blob blob = this.getContext().getForm().getFirstBlob();
        if (blob == null || blob.getLength() == 0L) {
            return null;
        }
        DocumentationService ds = (DocumentationService)Framework.getService(DocumentationService.class);
        ds.importDocumentation(this.getContext().getCoreSession(), blob.getStream());
        log.info((Object)"Documents imported.");
        return this.getView("docImportDone");
    }

    @GET
    @Path(value="_reindex")
    @Produces(value={"text/plain"})
    public Object reindex() {
        NuxeoPrincipal nxPrincipal = (NuxeoPrincipal)this.getContext().getPrincipal();
        if (!nxPrincipal.isAdministrator()) {
            return Response.status((int)404).build();
        }
        CoreSession coreSession = this.getContext().getCoreSession();
        String query = String.format("SELECT ecm:uuid FROM Document WHERE ecm:primaryType in ('%s') AND ecm:isProxy = 0 AND ecm:currentLifeCycleState <> 'deleted'", StringUtils.join((Iterable)AttributesExtractorStater.DOC_TYPES, (String)"','"));
        try (IterableQueryResult it = coreSession.queryAndFetch(query, "NXQL", new Object[]{QueryFilter.EMPTY});){
            for (Map map : it) {
                String id = (String)map.get("ecm:uuid");
                ExtractXmlAttributesWorker work = new ExtractXmlAttributesWorker(coreSession.getRepositoryName(), nxPrincipal.getName(), id);
                ((WorkManager)Framework.getLocalService(WorkManager.class)).schedule((Work)work);
            }
        }
        return Response.ok().build();
    }

    public boolean isEmbeddedMode() {
        Boolean embed = (Boolean)this.getContext().getProperty("embeddedMode", (Object)Boolean.FALSE);
        return embed != null && embed != false;
    }

    public boolean isEditor() {
        if (this.isEmbeddedMode() || Distribution.isSiteMode()) {
            return false;
        }
        NuxeoPrincipal principal = (NuxeoPrincipal)this.getContext().getPrincipal();
        return SecurityHelper.canEditDocumentation(principal);
    }

    public boolean canAddDocumentation() {
        NuxeoPrincipal principal = (NuxeoPrincipal)this.getContext().getPrincipal();
        return !this.isEmbeddedMode() && SecurityHelper.canEditDocumentation(principal);
    }

    public static boolean showCurrentDistribution() {
        return !Framework.isBooleanPropertyTrue((String)"org.nuxeo.apidoc.hide.current.distribution") && !Distribution.isSiteMode();
    }

    public static boolean showSeamComponent() {
        return !Framework.isBooleanPropertyTrue((String)"org.nuxeo.apidoc.hide.seam.components") && !Distribution.isSiteMode();
    }

    public static boolean isSiteMode() {
        return Framework.isBooleanPropertyTrue((String)"org.nuxeo.apidoc.site.mode");
    }
}

