/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.apidoc.doc;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.apidoc.api.AbstractDocumentationItem;
import org.nuxeo.apidoc.api.DocumentationItem;
import org.nuxeo.apidoc.doc.SimpleDocumentationItem;

@Provider
public class DocumentationItemReader
implements MessageBodyReader<DocumentationItem> {
    public static final MediaType DocumentationItemMediaType = new MediaType("application", "x-www-form-urlencoded");
    protected static final Log log = LogFactory.getLog(DocumentationItemReader.class);
    @Context
    protected HttpServletRequest request;

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return DocumentationItemMediaType.equals((Object)mediaType);
    }

    public DocumentationItem readFrom(Class<DocumentationItem> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        String[] attachmentsTitles;
        String[] versions;
        SimpleDocumentationItem item = new SimpleDocumentationItem(AbstractDocumentationItem.typeLabelOf((String)this.request.getParameter("type")));
        item.content = this.request.getParameter("content");
        item.id = this.request.getParameter("id");
        item.renderingType = this.request.getParameter("renderingType");
        item.target = this.request.getParameter("target");
        item.targetType = this.request.getParameter("targetType");
        item.title = this.request.getParameter("title");
        item.type = this.request.getParameter("type");
        item.uuid = this.request.getParameter("uuid");
        String v = this.request.getParameter("approved");
        if ("on".equals(v)) {
            item.approved = true;
        }
        if ((versions = this.request.getParameterValues("versions")) != null) {
            for (String version : versions) {
                item.applicableVersion.add(version);
            }
        }
        if ((attachmentsTitles = this.request.getParameterValues("attachmentsTitle")) != null && attachmentsTitles.length > 0) {
            String[] attachmentsContents = this.request.getParameterValues("attachmentsContent");
            LinkedHashMap<String, String> attachments = new LinkedHashMap<String, String>();
            int idx = 0;
            for (String attachmentsTitle : attachmentsTitles) {
                if (attachmentsContents.length > idx) {
                    attachments.put(attachmentsTitle, attachmentsContents[idx]);
                }
                ++idx;
            }
            item.attachments = attachments;
        }
        return item;
    }
}

