/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.apidoc.export;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.commons.io.IOUtils;
import org.nuxeo.apidoc.export.ArchiveFile;
import org.nuxeo.ecm.core.api.NuxeoException;

@Provider
@Produces(value={"*/*", "text/plain"})
public class ArchiveFileWriter
implements MessageBodyWriter<ArchiveFile> {
    public void writeTo(ArchiveFile t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        try (FileInputStream in = new FileInputStream(t);){
            IOUtils.copy((InputStream)in, (OutputStream)entityStream);
            entityStream.flush();
        }
        catch (IOException e) {
            throw new NuxeoException("Failed to render resource", (Throwable)e);
        }
        finally {
            if (t != null) {
                t.delete();
            }
        }
    }

    public long getSize(ArchiveFile arg0, Class<?> arg1, Type arg2, Annotation[] arg3, MediaType arg4) {
        long n = arg0.length();
        return n <= 0L ? -1L : n;
    }

    public boolean isWriteable(Class<?> arg0, Type type, Annotation[] arg2, MediaType arg3) {
        return ArchiveFile.class.isAssignableFrom(arg0);
    }
}

