/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.ui.json;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.nuxeo.common.utils.StringUtils;

public abstract class JQueryTreeBuilder<T> {
    public static final String CHILDREN = "children";

    public List<Map<String, Object>> buildTree(T root, String path) {
        String name;
        if (path == null || path.length() == 0 || "/".equals(path)) {
            return this.buildChildren(root);
        }
        String[] ar = StringUtils.split((String)path, (char)'/', (boolean)false);
        if (ar.length > 1 && (name = this.getName(root)).equals(ar[0])) {
            return this.buildChildren(root, ar, 1);
        }
        return this.buildChildren(root);
    }

    public List<Map<String, Object>> buildChildren(T parent) {
        ArrayList<Map<String, Object>> json = new ArrayList<Map<String, Object>>();
        Collection<T> children = this.getChildren(parent);
        if (children != null) {
            for (T obj : children) {
                Map<String, Object> map = this.toJson(obj);
                json.add(map);
            }
        }
        return json;
    }

    public List<Map<String, Object>> buildChildren(T parent, String[] path, int off) {
        ArrayList<Map<String, Object>> json = new ArrayList<Map<String, Object>>();
        String expandName = path[off];
        Collection<T> children = this.getChildren(parent);
        if (children != null) {
            for (T obj : children) {
                Map<String, Object> map = this.toJson(obj);
                String childName = this.getName(obj);
                if (expandName.equals(childName)) {
                    List<Map<String, Object>> jsonChildren = off < path.length - 1 ? this.buildChildren(obj, path, off + 1) : this.buildChildren(obj);
                    map.put(CHILDREN, jsonChildren);
                }
                json.add(map);
            }
        }
        return json;
    }

    protected abstract T getObject(String var1);

    protected abstract String getName(T var1);

    protected abstract Collection<T> getChildren(T var1);

    protected abstract Map<String, Object> toJson(T var1);
}

