/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.apidoc.tree;

import org.nuxeo.apidoc.api.AssociatedDocuments;
import org.nuxeo.apidoc.api.ComponentInfo;
import org.nuxeo.apidoc.api.NuxeoArtifact;
import org.nuxeo.ecm.core.api.CoreSession;

public class VirtualNode
implements NuxeoArtifact {
    protected final String cid;
    protected final String version;
    protected final String type;
    protected final String id;
    protected final String basePath;

    public VirtualNode(ComponentInfo ci, String type, String id) {
        this.cid = ci.getId();
        this.version = ci.getVersion();
        this.type = type;
        this.id = id;
        this.basePath = ci.getHierarchyPath();
    }

    public String getComponentId() {
        return this.cid;
    }

    public String getArtifactType() {
        return this.type;
    }

    public AssociatedDocuments getAssociatedDocuments(CoreSession session) {
        return null;
    }

    public String getId() {
        return this.id;
    }

    public String getVersion() {
        return this.version;
    }

    public String getHierarchyPath() {
        if ("ServicesContainer".equals(this.type)) {
            return this.basePath + "/" + "Services";
        }
        if ("ContributionsContainer".equals(this.type)) {
            return this.basePath + "/" + "Contributions";
        }
        if ("ExtensionPointsContainer".equals(this.type)) {
            return this.basePath + "/" + "ExtensionPoints";
        }
        return "";
    }

    public String getAnchor() {
        if ("ServicesContainer".equals(this.type)) {
            return "services";
        }
        if ("ExtensionPointsContainer".equals(this.type)) {
            return "extensionPoints";
        }
        if ("ContributionsContainer".equals(this.type)) {
            return "contributions";
        }
        return "";
    }
}

