/*
Get the (non-blob) setting passed in the setting parameter.
Convert its value according to the typeOfData field
returns JSON object:
{
  "setting": the setting's name,
  "found": boolean, true if the setting was found,
  "type": The type, as set in the Settings doc,
  "value": the value, in the correct type (a string, a nhumber, a boolean, a JSON object)
}

If the value is not found in the settings:
{
  "setting": the setting's name,
  "found": false,
  "type": null,
  "value": null
}

For a blob, call Settings_GetBlobSetting

*/
function run(input, params) {

  var setting, settingsDoc, settingsJava, i, oneSetting,
    value, returnValue, returnJson;

  setting = params.setting;
  if (!setting) {
    throw new org.nuxeo.ecm.core.api.NuxeoException("astSettings_GetSettingValue: Missing the 'setting' parameter");
  }

  // ==============================
  Auth.LoginAs(null, {});
  // ==============================
  settingsDoc = javascript.astSettings_GetDocCreateIfNeeded(null, {});
  settingsJava = settingsDoc["astsettings:settings"];

  returnValue = null;
  returnJson = {
    "setting": setting,
    "found": false,
    "type": null,
    "value": null
  };
  for (i = 0; i < settingsJava.size(); i++) {
    oneSetting = settingsJava[i];
    if (oneSetting.setting === setting && oneSetting.typeOfData !== "blob") {
      value = oneSetting.value;
      switch (oneSetting.typeOfData) {
        case "string":
          returnValue = value;
          break;

        case "int":
          returnValue = parseInt(value);
          break;

        case "double":
          returnValue = parseFloat(value);
          break;

        case "boolean":
          switch (value.toLowerCase()) {
            case "1":
            case "true":
              returnValue = true;
              break;

            default:
              returnValue = false;
              break;
          }
          break;

        case "json":
          returnValue = JSON.parse(value);
          break;
      }
      returnJson.found = true;
      returnJson.type = oneSetting.typeOfData;
      returnJson.value = returnValue;
      break;
    }
  }
  if (!returnJson.found) {
    Console.log("astSettings_GetSettingValue: setting '" + setting + "' not found.");
  }

  //Console.log("Result:\n" + JSON.stringify(returnJson, null, 2));

  // ==============================
  Auth.Logout(null, {});
  // ==============================

  return org.nuxeo.ecm.core.api.Blobs.createJSONBlob(JSON.stringify(returnJson));

}