/*
Just get the value. Returns null if not found.
*/
function run(input, params) {

  var settingLabel = params.setting;

  Auth.LoginAs(null, {});

  var settingsDoc = javascript.astSettings_GetDocCreateIfNeeded(null, {});
  var settingsJava = settingsDoc["astsettings:settings"];

  var settingValue = null;

  var i = 0;

  while (i < settingsJava.size()) {

    var oneSetting = settingsJava[i];

    if (oneSetting.setting === settingLabel && oneSetting.typeOfData !== "blob" && oneSetting.typeOfData !== "json") {

      var value = oneSetting.value;

      switch (oneSetting.typeOfData) {

        case "string":
          settingValue = value;
          break;

        case "int":
          settingValue = parseInt(value);
          break;

        case "double":
          settingValue = parseFloat(value);
          break;

        case "boolean":
          switch (value.toLowerCase()) {
            case "1":
            case "true":
              settingValue = true;
              break;

            default:
              settingValue = false;
              break;
          }
          break;

      }

    }

    i++;
  }

  Auth.Logout(null, {});

  return settingValue;

}