/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.model.impl;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.net.SocketException;
import java.security.Principal;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import javax.script.ScriptException;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.ExceptionUtils;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.platform.rendering.api.RenderingException;
import org.nuxeo.ecm.platform.web.common.locale.LocaleProvider;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.forms.FormData;
import org.nuxeo.ecm.webengine.jaxrs.session.SessionFactory;
import org.nuxeo.ecm.webengine.model.AdapterResource;
import org.nuxeo.ecm.webengine.model.Messages;
import org.nuxeo.ecm.webengine.model.Module;
import org.nuxeo.ecm.webengine.model.ModuleResource;
import org.nuxeo.ecm.webengine.model.Resource;
import org.nuxeo.ecm.webengine.model.ResourceType;
import org.nuxeo.ecm.webengine.model.WebContext;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;
import org.nuxeo.ecm.webengine.scripting.ScriptFile;
import org.nuxeo.ecm.webengine.security.PermissionService;
import org.nuxeo.ecm.webengine.session.UserSession;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractWebContext
implements WebContext {
    private static final Log log = LogFactory.getLog(WebContext.class);
    protected static final Locale DEFAULT_LOCALE = Locale.ENGLISH;
    public static final String LOCALE_SESSION_KEY = "webengine_locale";
    private static boolean isRepositoryDisabled = false;
    protected final WebEngine engine = (WebEngine)Framework.getService(WebEngine.class);
    private UserSession us;
    protected final LinkedList<File> scriptExecutionStack = new LinkedList();
    protected final HttpServletRequest request;
    protected final HttpServletResponse response;
    protected final Map<String, Object> vars;
    protected Resource head;
    protected Resource tail;
    protected Resource root;
    protected Module module;
    protected FormData form;
    protected String basePath;
    private String repoName;

    protected AbstractWebContext(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
        this.vars = new HashMap<String, Object>();
    }

    public void setModule(Module module) {
        this.module = module;
    }

    @Override
    public Resource getRoot() {
        return this.root;
    }

    @Override
    public void setRoot(Resource root) {
        this.root = root;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (CoreSession.class == adapter) {
            return adapter.cast(this.getCoreSession());
        }
        if (Principal.class == adapter) {
            return adapter.cast(this.getPrincipal());
        }
        if (NuxeoPrincipal.class == adapter) {
            return adapter.cast(this.getPrincipal());
        }
        if (Resource.class == adapter) {
            return adapter.cast(this.tail());
        }
        if (WebContext.class == adapter) {
            return adapter.cast(this);
        }
        if (Module.class == adapter) {
            return adapter.cast(this.module);
        }
        if (WebEngine.class == adapter) {
            return adapter.cast(this.engine);
        }
        return null;
    }

    @Override
    public Module getModule() {
        return this.module;
    }

    @Override
    public WebEngine getEngine() {
        return this.engine;
    }

    @Override
    public UserSession getUserSession() {
        if (this.us == null) {
            this.us = UserSession.getCurrentSession(this.request);
        }
        return this.us;
    }

    @Override
    public CoreSession getCoreSession() {
        if (StringUtils.isNotBlank((CharSequence)this.repoName)) {
            return SessionFactory.getSession((HttpServletRequest)this.request, (String)this.repoName);
        }
        return SessionFactory.getSession((HttpServletRequest)this.request);
    }

    @Override
    public NuxeoPrincipal getPrincipal() {
        return (NuxeoPrincipal)this.request.getUserPrincipal();
    }

    @Override
    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    @Override
    public String getMethod() {
        return this.request.getMethod();
    }

    @Override
    public String getModulePath() {
        return this.head.getPath();
    }

    @Override
    public String getMessage(String key) {
        Messages messages = this.module.getMessages();
        try {
            return messages.getString(key, this.getLocale().getLanguage());
        }
        catch (MissingResourceException e) {
            return '!' + key + '!';
        }
    }

    @Override
    public String getMessage(String key, Object ... args) {
        Messages messages = this.module.getMessages();
        try {
            String msg = messages.getString(key, this.getLocale().getLanguage());
            if (args != null && args.length > 0) {
                msg = MessageFormat.format(msg, args);
            }
            return msg;
        }
        catch (MissingResourceException e) {
            return '!' + key + '!';
        }
    }

    @Override
    public String getMessage(String key, List<Object> args) {
        Messages messages = this.module.getMessages();
        try {
            String msg = messages.getString(key, this.getLocale().getLanguage());
            if (CollectionUtils.isNotEmpty(args)) {
                msg = MessageFormat.format(msg, args.toArray());
            }
            return msg;
        }
        catch (MissingResourceException e) {
            return '!' + key + '!';
        }
    }

    @Override
    public String getMessageL(String key, String language) {
        Messages messages = this.module.getMessages();
        try {
            return messages.getString(key, language);
        }
        catch (MissingResourceException e) {
            return '!' + key + '!';
        }
    }

    @Override
    public String getMessageL(String key, String locale, Object ... args) {
        Messages messages = this.module.getMessages();
        try {
            String msg = messages.getString(key, locale);
            if (args != null && args.length > 0) {
                msg = MessageFormat.format(msg, args);
            }
            return msg;
        }
        catch (MissingResourceException e) {
            return '!' + key + '!';
        }
    }

    @Override
    public String getMessageL(String key, String locale, List<Object> args) {
        Messages messages = this.module.getMessages();
        try {
            String msg = messages.getString(key, locale);
            if (args != null && !args.isEmpty()) {
                msg = MessageFormat.format(msg, args.toArray());
            }
            return msg;
        }
        catch (MissingResourceException e) {
            return '!' + key + '!';
        }
    }

    @Override
    public Locale getLocale() {
        Object locale;
        Locale userPrefLocale;
        LocaleProvider localeProvider = (LocaleProvider)Framework.getService(LocaleProvider.class);
        if (localeProvider != null && this.request.getUserPrincipal() != null && (userPrefLocale = localeProvider.getLocale(this.getCoreSession())) != null) {
            return userPrefLocale;
        }
        UserSession userSession = this.getUserSession();
        if (userSession != null && (locale = userSession.get(LOCALE_SESSION_KEY)) instanceof Locale) {
            return (Locale)locale;
        }
        locale = this.request.getLocale();
        return locale == null ? DEFAULT_LOCALE : locale;
    }

    @Override
    public void setLocale(Locale locale) {
        UserSession userSession = this.getUserSession();
        if (userSession != null) {
            userSession.put(LOCALE_SESSION_KEY, locale);
        }
    }

    @Override
    public Resource newObject(String typeName, Object ... args) {
        ResourceType type = this.module.getType(typeName);
        if (type == null) {
            throw new WebResourceNotFoundException("No Such Object Type: " + typeName);
        }
        return this.newObject(type, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Resource newObject(ResourceType type, Object ... args) {
        Resource obj = type.newInstance(type.getResourceClass(), this);
        try {
            obj.initialize(this, type, args);
        }
        finally {
            this.push(obj);
        }
        return obj;
    }

    @Override
    public AdapterResource newAdapter(Resource ctx, String serviceName, Object ... args) {
        return (AdapterResource)this.newObject(this.module.getAdapter(ctx, serviceName), args);
    }

    @Override
    public void setProperty(String key, Object value) {
        this.vars.put(key, value);
    }

    @Override
    public Object getProperty(String key) {
        Object value = this.getUriInfo().getPathParameters().getFirst((Object)key);
        if (value == null && (value = this.request.getParameter(key)) == null) {
            value = this.vars.get(key);
        }
        return value;
    }

    @Override
    public Object getProperty(String key, Object defaultValue) {
        Object value = this.getProperty(key);
        return value == null ? defaultValue : value;
    }

    @Override
    public String getCookie(String name) {
        Cookie[] cookies = this.request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!name.equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    @Override
    public String getCookie(String name, String defaultValue) {
        String value = this.getCookie(name);
        return value == null ? defaultValue : value;
    }

    @Override
    public FormData getForm() {
        if (this.form == null) {
            this.form = new FormData(this.request);
        }
        return this.form;
    }

    @Override
    public String getBasePath() {
        if (this.basePath == null) {
            String webenginePath = this.request.getHeader("nuxeo-webengine-base-path");
            if (",".equals(webenginePath)) {
                webenginePath = "";
            }
            this.basePath = webenginePath != null ? webenginePath : this.getDefaultBasePath();
        }
        return this.basePath;
    }

    private String getDefaultBasePath() {
        StringBuilder buf = new StringBuilder(this.request.getRequestURI().length());
        String path = this.request.getContextPath();
        if (path == null) {
            path = "/nuxeo/site";
        }
        buf.append(path).append(this.request.getServletPath());
        if ("/".equals(path)) {
            return "";
        }
        int len = buf.length();
        if (len > 0 && buf.charAt(len - 1) == '/') {
            buf.setLength(len - 1);
        }
        return buf.toString();
    }

    @Override
    public String getBaseURL() {
        StringBuffer sb = this.request.getRequestURL();
        int p = sb.indexOf(this.getBasePath());
        if (p > -1) {
            return sb.substring(0, p);
        }
        return sb.toString();
    }

    @Override
    public StringBuilder getServerURL() {
        StringBuilder url = new StringBuilder(VirtualHostHelper.getServerURL((ServletRequest)this.request));
        if (url.toString().endsWith("/")) {
            url.deleteCharAt(url.length() - 1);
        }
        return url;
    }

    @Override
    public String getURI() {
        return this.request.getRequestURI();
    }

    @Override
    public String getURL() {
        StringBuffer sb = this.request.getRequestURL();
        if (sb.charAt(sb.length() - 1) == '/') {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public StringBuilder getUrlPathBuffer() {
        StringBuilder buf = new StringBuilder(this.getBasePath());
        String pathInfo = this.request.getPathInfo();
        if (pathInfo != null) {
            buf.append(pathInfo);
        }
        return buf;
    }

    @Override
    public String getUrlPath() {
        return this.getUrlPathBuffer().toString();
    }

    @Override
    public String getLoginPath() {
        StringBuilder buf = this.getUrlPathBuffer();
        int len = buf.length();
        if (len > 0 && buf.charAt(len - 1) == '/') {
            buf.setLength(len - 1);
        }
        buf.append("/@@login");
        return buf.toString();
    }

    @Override
    public String getUrlPath(DocumentModel document) {
        return ((ModuleResource)this.head).getLink(document);
    }

    @Override
    public Log getLog() {
        return log;
    }

    @Override
    public Resource push(Resource rs) {
        rs.setPrevious(this.tail);
        if (this.tail != null) {
            this.tail.setNext(rs);
            this.tail = rs;
        } else {
            this.head = this.tail = rs;
        }
        return rs;
    }

    @Override
    public Resource pop() {
        if (this.tail == null) {
            return null;
        }
        Resource rs = this.tail;
        if (this.tail == this.head) {
            this.tail = null;
            this.head = null;
        } else {
            this.tail = rs.getPrevious();
            this.tail.setNext(null);
        }
        rs.dispose();
        return rs;
    }

    @Override
    public Resource tail() {
        return this.tail;
    }

    @Override
    public Resource head() {
        return this.head;
    }

    @Override
    public ScriptFile getFile(String path) {
        if (path == null || path.length() == 0) {
            return null;
        }
        char c = path.charAt(0);
        if (c == '.') {
            File file = this.getCurrentScriptDirectory();
            if (file != null) {
                try {
                    file = new File(file, path).getCanonicalFile();
                    if (file.isFile()) {
                        return new ScriptFile(file);
                    }
                }
                catch (IOException e) {
                    throw new NuxeoException((Throwable)e);
                }
                String rootPath = this.engine.getRootDirectory().getAbsolutePath();
                String filePath = file.getAbsolutePath();
                path = filePath.substring(rootPath.length());
            } else {
                log.warn((Object)"Relative path used but there is any running script");
                path = new Path(path).makeAbsolute().toString();
            }
        }
        return this.module.getFile(path);
    }

    public void pushScriptFile(File file) {
        if (this.scriptExecutionStack.size() > 64) {
            throw new IllegalStateException("Script execution stack overflowed. More than 64 calls between scripts");
        }
        if (file == null) {
            throw new IllegalArgumentException("Cannot push a null file");
        }
        this.scriptExecutionStack.add(file);
    }

    public File popScriptFile() {
        int size = this.scriptExecutionStack.size();
        if (size == 0) {
            throw new IllegalStateException("Script execution stack underflowed. No script path to pop");
        }
        return this.scriptExecutionStack.remove(size - 1);
    }

    public File getCurrentScriptFile() {
        int size = this.scriptExecutionStack.size();
        if (size == 0) {
            return null;
        }
        return this.scriptExecutionStack.get(size - 1);
    }

    public File getCurrentScriptDirectory() {
        int size = this.scriptExecutionStack.size();
        if (size == 0) {
            return null;
        }
        return this.scriptExecutionStack.get(size - 1).getParentFile();
    }

    @Override
    public void render(String template, Writer writer) {
        this.render(template, null, writer);
    }

    @Override
    public void render(String template, Object ctx, Writer writer) {
        ScriptFile script = this.getFile(template);
        if (script == null) {
            throw new WebResourceNotFoundException("Template not found: " + template);
        }
        this.render(script, ctx, writer);
    }

    @Override
    public void render(ScriptFile script, Object ctx, Writer writer) {
        Map map = null;
        if (ctx instanceof Map) {
            map = (Map)ctx;
        }
        try {
            String template = script.getURL();
            Map<String, Object> bindings = this.createBindings(map);
            if (log.isDebugEnabled()) {
                log.debug((Object)("## Rendering: " + template));
            }
            this.pushScriptFile(script.getFile());
            this.engine.getRendering().render(template, bindings, writer);
        }
        catch (IOException | RenderingException e) {
            Throwable cause = ExceptionUtils.getRootCause((Throwable)e);
            if (cause instanceof SocketException) {
                log.debug((Object)"Output socket closed: failed to write response", e);
                return;
            }
            throw new NuxeoException("Failed to render template: " + (script == null ? script : script.getAbsolutePath()), e);
        }
        finally {
            if (!this.scriptExecutionStack.isEmpty()) {
                this.popScriptFile();
            }
        }
    }

    @Override
    public Object runScript(String script) {
        return this.runScript(script, null);
    }

    @Override
    public Object runScript(String script, Map<String, Object> args) {
        ScriptFile sf = this.getFile(script);
        if (sf != null) {
            return this.runScript(sf, args);
        }
        throw new WebResourceNotFoundException("Script not found: " + script);
    }

    @Override
    public Object runScript(ScriptFile script, Map<String, Object> args) {
        try {
            this.pushScriptFile(script.getFile());
            Object object = this.engine.getScripting().runScript(script, this.createBindings(args));
            return object;
        }
        catch (ScriptException e) {
            throw new NuxeoException("Failed to run script " + script, (Throwable)e);
        }
        finally {
            if (!this.scriptExecutionStack.isEmpty()) {
                this.popScriptFile();
            }
        }
    }

    @Override
    public boolean checkGuard(String guard) throws ParseException {
        return PermissionService.parse(guard).check(this);
    }

    public Map<String, Object> createBindings(Map<String, Object> vars) {
        HashMap<String, Object> bindings = new HashMap<String, Object>();
        if (vars != null) {
            bindings.putAll(vars);
        }
        this.initializeBindings(bindings);
        return bindings;
    }

    @Override
    public Resource getTargetObject() {
        for (Resource t = this.tail; t != null; t = t.getPrevious()) {
            if (t.isAdapter()) continue;
            return t;
        }
        return null;
    }

    @Override
    public AdapterResource getTargetAdapter() {
        for (Resource t = this.tail; t != null; t = t.getPrevious()) {
            if (!t.isAdapter()) continue;
            return (AdapterResource)t;
        }
        return null;
    }

    protected void initializeBindings(Map<String, Object> bindings) {
        Resource obj = this.getTargetObject();
        bindings.put("Context", this);
        bindings.put("Module", this.module);
        bindings.put("Engine", this.engine);
        bindings.put("Runtime", Framework.getRuntime());
        bindings.put("basePath", this.getBasePath());
        bindings.put("skinPath", this.getSkinPathPrefix());
        bindings.put("contextPath", VirtualHostHelper.getContextPathProperty());
        bindings.put("Root", this.root);
        if (obj != null) {
            AdapterResource adapter;
            bindings.put("This", obj);
            DocumentModel doc = (DocumentModel)obj.getAdapter(DocumentModel.class);
            if (doc != null) {
                bindings.put("Document", doc);
            }
            if ((adapter = this.getTargetAdapter()) != null) {
                bindings.put("Adapter", adapter);
            }
        }
        if (!isRepositoryDisabled && this.getPrincipal() != null) {
            bindings.put("Session", this.getCoreSession());
        }
    }

    private String getSkinPathPrefix() {
        if (Framework.getProperty((String)"org.nuxeo.ecm.webengine.skinPathPrefix") != null) {
            return this.module.getSkinPathPrefix();
        }
        String webenginePath = this.request.getHeader("nuxeo-webengine-base-path");
        if (webenginePath == null) {
            return this.module.getSkinPathPrefix();
        }
        return this.getBasePath() + "/" + this.module.getName() + "/skin";
    }

    public static boolean isRepositorySupportDisabled() {
        return isRepositoryDisabled;
    }

    public static void setIsRepositorySupportDisabled(boolean isRepositoryDisabled) {
        AbstractWebContext.isRepositoryDisabled = isRepositoryDisabled;
    }

    @Override
    public void setRepositoryName(String repoName) {
        RepositoryManager rm = (RepositoryManager)Framework.getService(RepositoryManager.class);
        if (rm.getRepository(repoName) == null) {
            throw new IllegalArgumentException("Repository " + repoName + " not found");
        }
        this.repoName = repoName;
        this.request.setAttribute("X-NXRepository", (Object)repoName);
    }
}

